/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SshAuthenticationMethod {
    PASSWORD("password"),
    PUBLICKEY("publickey");

    private static final Logger log;
    private String image;

    private SshAuthenticationMethod(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static SshAuthenticationMethod fromValue(String value) {
        try {
            return SshAuthenticationMethod.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'SshAuthenticationMethod' enumerated type. Valid values are 'password' and 'publickey'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(SshAuthenticationMethod.class);
    }
}

