/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.CpuTopologyContainer;
import org.ovirt.engine.sdk4.types.CpuTopology;

public class CpuTopologyBuilder {
    private BigInteger cores;
    private BigInteger sockets;
    private BigInteger threads;

    public CpuTopologyBuilder cores(int newCores) {
        this.cores = BigInteger.valueOf(newCores);
        return this;
    }

    public CpuTopologyBuilder cores(Integer newCores) {
        this.cores = newCores == null ? null : BigInteger.valueOf(newCores.longValue());
        return this;
    }

    public CpuTopologyBuilder cores(long newCores) {
        this.cores = BigInteger.valueOf(newCores);
        return this;
    }

    public CpuTopologyBuilder cores(Long newCores) {
        this.cores = newCores == null ? null : BigInteger.valueOf(newCores);
        return this;
    }

    public CpuTopologyBuilder cores(BigInteger newCores) {
        this.cores = newCores;
        return this;
    }

    public CpuTopologyBuilder sockets(int newSockets) {
        this.sockets = BigInteger.valueOf(newSockets);
        return this;
    }

    public CpuTopologyBuilder sockets(Integer newSockets) {
        this.sockets = newSockets == null ? null : BigInteger.valueOf(newSockets.longValue());
        return this;
    }

    public CpuTopologyBuilder sockets(long newSockets) {
        this.sockets = BigInteger.valueOf(newSockets);
        return this;
    }

    public CpuTopologyBuilder sockets(Long newSockets) {
        this.sockets = newSockets == null ? null : BigInteger.valueOf(newSockets);
        return this;
    }

    public CpuTopologyBuilder sockets(BigInteger newSockets) {
        this.sockets = newSockets;
        return this;
    }

    public CpuTopologyBuilder threads(int newThreads) {
        this.threads = BigInteger.valueOf(newThreads);
        return this;
    }

    public CpuTopologyBuilder threads(Integer newThreads) {
        this.threads = newThreads == null ? null : BigInteger.valueOf(newThreads.longValue());
        return this;
    }

    public CpuTopologyBuilder threads(long newThreads) {
        this.threads = BigInteger.valueOf(newThreads);
        return this;
    }

    public CpuTopologyBuilder threads(Long newThreads) {
        this.threads = newThreads == null ? null : BigInteger.valueOf(newThreads);
        return this;
    }

    public CpuTopologyBuilder threads(BigInteger newThreads) {
        this.threads = newThreads;
        return this;
    }

    public CpuTopology build() {
        CpuTopologyContainer container = new CpuTopologyContainer();
        container.cores(this.cores);
        container.sockets(this.sockets);
        container.threads(this.threads);
        return container;
    }
}

