/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.OptionBuilder;
import org.ovirt.engine.sdk4.internal.containers.AgentContainer;
import org.ovirt.engine.sdk4.types.Agent;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Option;

public class AgentBuilder {
    private String address;
    private String comment;
    private Boolean concurrent;
    private String description;
    private Boolean encryptOptions;
    private Host host;
    private String href;
    private String id;
    private String name;
    private List<Option> options;
    private BigInteger order;
    private String password;
    private BigInteger port;
    private String type;
    private String username;

    public AgentBuilder address(String newAddress) {
        this.address = newAddress;
        return this;
    }

    public AgentBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public AgentBuilder concurrent(boolean newConcurrent) {
        this.concurrent = newConcurrent;
        return this;
    }

    public AgentBuilder concurrent(Boolean newConcurrent) {
        this.concurrent = newConcurrent;
        return this;
    }

    public AgentBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public AgentBuilder encryptOptions(boolean newEncryptOptions) {
        this.encryptOptions = newEncryptOptions;
        return this;
    }

    public AgentBuilder encryptOptions(Boolean newEncryptOptions) {
        this.encryptOptions = newEncryptOptions;
        return this;
    }

    public AgentBuilder host(Host newHost) {
        this.host = newHost;
        return this;
    }

    public AgentBuilder host(HostBuilder newHost) {
        this.host = newHost == null ? null : newHost.build();
        return this;
    }

    public AgentBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public AgentBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public AgentBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public AgentBuilder options(List<Option> newOptions) {
        if (newOptions != null) {
            if (this.options == null) {
                this.options = new ArrayList<Option>(newOptions);
            } else {
                this.options.addAll(newOptions);
            }
        }
        return this;
    }

    public AgentBuilder options(Option ... newOptions) {
        if (newOptions != null) {
            if (this.options == null) {
                this.options = new ArrayList<Option>(newOptions.length);
            }
            Collections.addAll(this.options, newOptions);
        }
        return this;
    }

    public AgentBuilder options(OptionBuilder ... newOptions) {
        if (newOptions != null) {
            if (this.options == null) {
                this.options = new ArrayList<Option>(newOptions.length);
            }
            for (OptionBuilder builder : newOptions) {
                this.options.add(builder.build());
            }
        }
        return this;
    }

    public AgentBuilder order(int newOrder) {
        this.order = BigInteger.valueOf(newOrder);
        return this;
    }

    public AgentBuilder order(Integer newOrder) {
        this.order = newOrder == null ? null : BigInteger.valueOf(newOrder.longValue());
        return this;
    }

    public AgentBuilder order(long newOrder) {
        this.order = BigInteger.valueOf(newOrder);
        return this;
    }

    public AgentBuilder order(Long newOrder) {
        this.order = newOrder == null ? null : BigInteger.valueOf(newOrder);
        return this;
    }

    public AgentBuilder order(BigInteger newOrder) {
        this.order = newOrder;
        return this;
    }

    public AgentBuilder password(String newPassword) {
        this.password = newPassword;
        return this;
    }

    public AgentBuilder port(int newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public AgentBuilder port(Integer newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort.longValue());
        return this;
    }

    public AgentBuilder port(long newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public AgentBuilder port(Long newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort);
        return this;
    }

    public AgentBuilder port(BigInteger newPort) {
        this.port = newPort;
        return this;
    }

    public AgentBuilder type(String newType) {
        this.type = newType;
        return this;
    }

    public AgentBuilder username(String newUsername) {
        this.username = newUsername;
        return this;
    }

    public Agent build() {
        AgentContainer container = new AgentContainer();
        container.address(this.address);
        container.comment(this.comment);
        container.concurrent(this.concurrent);
        container.description(this.description);
        container.encryptOptions(this.encryptOptions);
        container.host(this.host);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.options(this.options);
        container.order(this.order);
        container.password(this.password);
        container.port(this.port);
        container.type(this.type);
        container.username(this.username);
        return container;
    }
}

