/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.MigrationBandwidth;
import org.ovirt.engine.sdk4.types.MigrationBandwidthAssignmentMethod;

public class MigrationBandwidthContainer extends Container implements MigrationBandwidth {
    private MigrationBandwidthAssignmentMethod assignmentMethod;
    private BigInteger customValue;
    
    public MigrationBandwidthAssignmentMethod assignmentMethod() {
        return assignmentMethod;
    }
    
    public void assignmentMethod(MigrationBandwidthAssignmentMethod newAssignmentMethod) {
        assignmentMethod = newAssignmentMethod;
    }
    
    public boolean assignmentMethodPresent() {
        return assignmentMethod != null;
    }
    
    public BigInteger customValue() {
        return customValue;
    }
    
    public Byte customValueAsByte() {
        return asByte("MigrationBandwidth", "customValue", customValue);
    }
    
    public Short customValueAsShort() {
        return asShort("MigrationBandwidth", "customValue", customValue);
    }
    
    public Integer customValueAsInteger() {
        return asInteger("MigrationBandwidth", "customValue", customValue);
    }
    
    public Long customValueAsLong() {
        return asLong("MigrationBandwidth", "customValue", customValue);
    }
    
    public void customValue(BigInteger newCustomValue) {
        customValue = newCustomValue;
    }
    
    public boolean customValuePresent() {
        return customValue != null;
    }
    
}
