/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.GlusterClient;

public class GlusterClientContainer extends Container implements GlusterClient {
    private BigInteger bytesRead;
    private BigInteger bytesWritten;
    private BigInteger clientPort;
    private String hostName;
    
    public BigInteger bytesRead() {
        return bytesRead;
    }
    
    public void bytesRead(BigInteger newBytesRead) {
        bytesRead = newBytesRead;
    }
    
    public boolean bytesReadPresent() {
        return bytesRead != null;
    }
    
    public BigInteger bytesWritten() {
        return bytesWritten;
    }
    
    public void bytesWritten(BigInteger newBytesWritten) {
        bytesWritten = newBytesWritten;
    }
    
    public boolean bytesWrittenPresent() {
        return bytesWritten != null;
    }
    
    public BigInteger clientPort() {
        return clientPort;
    }
    
    public void clientPort(BigInteger newClientPort) {
        clientPort = newClientPort;
    }
    
    public boolean clientPortPresent() {
        return clientPort != null;
    }
    
    public String hostName() {
        return hostName;
    }
    
    public void hostName(String newHostName) {
        hostName = newHostName;
    }
    
    public boolean hostNamePresent() {
        return hostName != null;
    }
    
}
