/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.IscsiBond;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.StorageConnection;

public class IscsiBondContainer extends IdentifiedContainer implements IscsiBond {
    private DataCenter dataCenter;
    private List<Network> networks;
    private List<StorageConnection> storageConnections;
    
    public DataCenter dataCenter() {
        return dataCenter;
    }
    
    public void dataCenter(DataCenter newDataCenter) {
        dataCenter = newDataCenter;
    }
    
    public boolean dataCenterPresent() {
        return dataCenter != null;
    }
    
    public List<Network> networks() {
        return makeUnmodifiableList(networks);
    }
    
    public void networks(List<Network> newNetworks) {
        networks = makeArrayList(newNetworks);
    }
    
    public boolean networksPresent() {
        return networks != null && !networks.isEmpty();
    }
    
    public List<StorageConnection> storageConnections() {
        return makeUnmodifiableList(storageConnections);
    }
    
    public void storageConnections(List<StorageConnection> newStorageConnections) {
        storageConnections = makeArrayList(newStorageConnections);
    }
    
    public boolean storageConnectionsPresent() {
        return storageConnections != null && !storageConnections.isEmpty();
    }
    
}
