/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import java.lang.String;
import org.ovirt.engine.sdk4.types.Ip;
import org.ovirt.engine.sdk4.types.Session;
import org.ovirt.engine.sdk4.types.User;
import org.ovirt.engine.sdk4.types.Vm;

public class SessionContainer extends IdentifiedContainer implements Session {
    private Boolean consoleUser;
    private Ip ip;
    private String protocol;
    private User user;
    private Vm vm;
    
    public boolean consoleUser() {
        return consoleUser;
    }
    
    public void consoleUser(boolean newConsoleUser) {
        consoleUser = Boolean.valueOf(newConsoleUser);
    }
    
    public void consoleUser(Boolean newConsoleUser) {
        consoleUser = newConsoleUser;
    }
    
    public boolean consoleUserPresent() {
        return consoleUser != null;
    }
    
    public Ip ip() {
        return ip;
    }
    
    public void ip(Ip newIp) {
        ip = newIp;
    }
    
    public boolean ipPresent() {
        return ip != null;
    }
    
    public String protocol() {
        return protocol;
    }
    
    public void protocol(String newProtocol) {
        protocol = newProtocol;
    }
    
    public boolean protocolPresent() {
        return protocol != null;
    }
    
    public User user() {
        return user;
    }
    
    public void user(User newUser) {
        user = newUser;
    }
    
    public boolean userPresent() {
        return user != null;
    }
    
    public Vm vm() {
        return vm;
    }
    
    public void vm(Vm newVm) {
        vm = newVm;
    }
    
    public boolean vmPresent() {
        return vm != null;
    }
    
}
