/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.Quota;
import org.ovirt.engine.sdk4.types.QuotaStorageLimit;
import org.ovirt.engine.sdk4.types.StorageDomain;

public class QuotaStorageLimitContainer extends IdentifiedContainer implements QuotaStorageLimit {
    private BigInteger limit;
    private BigDecimal usage;
    private Quota quota;
    private StorageDomain storageDomain;
    
    public BigInteger limit() {
        return limit;
    }
    
    public void limit(BigInteger newLimit) {
        limit = newLimit;
    }
    
    public boolean limitPresent() {
        return limit != null;
    }
    
    public BigDecimal usage() {
        return usage;
    }
    
    public void usage(BigDecimal newUsage) {
        usage = newUsage;
    }
    
    public boolean usagePresent() {
        return usage != null;
    }
    
    public Quota quota() {
        return quota;
    }
    
    public void quota(Quota newQuota) {
        quota = newQuota;
    }
    
    public boolean quotaPresent() {
        return quota != null;
    }
    
    public StorageDomain storageDomain() {
        return storageDomain;
    }
    
    public void storageDomain(StorageDomain newStorageDomain) {
        storageDomain = newStorageDomain;
    }
    
    public boolean storageDomainPresent() {
        return storageDomain != null;
    }
    
}
