/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.QosContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlDataCenterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQosTypeReader;
import org.ovirt.engine.sdk4.types.Qos;

public class XmlQosReader {
    public static Qos readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        QosContainer object = new QosContainer();
        block56: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block56;
                }
                case "id": {
                    object.id(image);
                    continue block56;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block57: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block57;
                }
                case "cpu_limit": {
                    object.cpuLimit(reader.readInteger());
                    continue block57;
                }
                case "data_center": {
                    object.dataCenter(XmlDataCenterReader.readOne(reader));
                    continue block57;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block57;
                }
                case "inbound_average": {
                    object.inboundAverage(reader.readInteger());
                    continue block57;
                }
                case "inbound_burst": {
                    object.inboundBurst(reader.readInteger());
                    continue block57;
                }
                case "inbound_peak": {
                    object.inboundPeak(reader.readInteger());
                    continue block57;
                }
                case "max_iops": {
                    object.maxIops(reader.readInteger());
                    continue block57;
                }
                case "max_read_iops": {
                    object.maxReadIops(reader.readInteger());
                    continue block57;
                }
                case "max_read_throughput": {
                    object.maxReadThroughput(reader.readInteger());
                    continue block57;
                }
                case "max_throughput": {
                    object.maxThroughput(reader.readInteger());
                    continue block57;
                }
                case "max_write_iops": {
                    object.maxWriteIops(reader.readInteger());
                    continue block57;
                }
                case "max_write_throughput": {
                    object.maxWriteThroughput(reader.readInteger());
                    continue block57;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block57;
                }
                case "outbound_average": {
                    object.outboundAverage(reader.readInteger());
                    continue block57;
                }
                case "outbound_average_linkshare": {
                    object.outboundAverageLinkshare(reader.readInteger());
                    continue block57;
                }
                case "outbound_average_realtime": {
                    object.outboundAverageRealtime(reader.readInteger());
                    continue block57;
                }
                case "outbound_average_upperlimit": {
                    object.outboundAverageUpperlimit(reader.readInteger());
                    continue block57;
                }
                case "outbound_burst": {
                    object.outboundBurst(reader.readInteger());
                    continue block57;
                }
                case "outbound_peak": {
                    object.outboundPeak(reader.readInteger());
                    continue block57;
                }
                case "type": {
                    object.type(XmlQosTypeReader.readOne(reader));
                    continue block57;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block57;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlQosReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Qos> iterateMany(final XmlReader reader) {
        return new Iterator<Qos>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Qos next() {
                Qos next = XmlQosReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Qos> readMany(XmlReader reader) {
        ArrayList<Qos> list = new ArrayList<Qos>();
        Iterator<Qos> iterator = XmlQosReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(QosContainer object, String[] link) {
    }
}

