/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.DiskProfileContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlPermissionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQosReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageDomainReader;
import org.ovirt.engine.sdk4.types.DiskProfile;
import org.ovirt.engine.sdk4.types.Permission;

public class XmlDiskProfileReader {
    public static DiskProfile readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        DiskProfileContainer object = new DiskProfileContainer();
        block26: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block26;
                }
                case "id": {
                    object.id(image);
                    continue block26;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block27: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block27;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block27;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block27;
                }
                case "permissions": {
                    object.permissions(XmlPermissionReader.readMany(reader));
                    continue block27;
                }
                case "qos": {
                    object.qos(XmlQosReader.readOne(reader));
                    continue block27;
                }
                case "storage_domain": {
                    object.storageDomain(XmlStorageDomainReader.readOne(reader));
                    continue block27;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block27;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlDiskProfileReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<DiskProfile> iterateMany(final XmlReader reader) {
        return new Iterator<DiskProfile>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public DiskProfile next() {
                DiskProfile next = XmlDiskProfileReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<DiskProfile> readMany(XmlReader reader) {
        ArrayList<DiskProfile> list = new ArrayList<DiskProfile>();
        Iterator<DiskProfile> iterator = XmlDiskProfileReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(DiskProfileContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "permissions": {
                    ArrayListWithHref<Permission> list = new ArrayListWithHref<Permission>(object.permissions());
                    list.href(href);
                    object.permissions(list);
                    break;
                }
            }
        }
    }
}

