/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.Architecture;
import org.ovirt.engine.sdk4.types.CpuType;

public class CpuTypeContainer extends Container implements CpuType {
    private Architecture architecture;
    private BigInteger level;
    private String name;
    
    public Architecture architecture() {
        return architecture;
    }
    
    public void architecture(Architecture newArchitecture) {
        architecture = newArchitecture;
    }
    
    public boolean architecturePresent() {
        return architecture != null;
    }
    
    public BigInteger level() {
        return level;
    }
    
    public void level(BigInteger newLevel) {
        level = newLevel;
    }
    
    public boolean levelPresent() {
        return level != null;
    }
    
    public String name() {
        return name;
    }
    
    public void name(String newName) {
        name = newName;
    }
    
    public boolean namePresent() {
        return name != null;
    }
    
}
