/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.types.GlusterBrick;

public interface GlusterBrickService extends Service {
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    public interface GetResponse extends Response {
        GlusterBrick brick();
    }
    
    GetRequest get();
    
    /**
     * Removes this brick from the volume and deletes it from the database.
     */
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
        /**
         * Indicates if the remove should be performed asynchronously.
         */
        RemoveRequest async(Boolean async);
    }
    
    /**
     * Removes this brick from the volume and deletes it from the database.
     */
    public interface RemoveResponse extends Response {
    }
    
    /**
     * Removes this brick from the volume and deletes it from the database.
     */
    RemoveRequest remove();
    
    /**
     * Replaces this brick with a new one. The property `brick` is required.
     */
    public interface ReplaceRequest extends Request<ReplaceRequest, ReplaceResponse> {
        /**
         * Indicates if the replacement should be performed asynchronously.
         */
        ReplaceRequest async(Boolean async);
        ReplaceRequest force(Boolean force);
    }
    
    /**
     * Replaces this brick with a new one. The property `brick` is required.
     */
    public interface ReplaceResponse extends Response {
    }
    
    /**
     * Replaces this brick with a new one. The property `brick` is required.
     */
    ReplaceRequest replace();
    
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

