%global         package_version 1.6.3

# Skips check since rhel default repos lack flake8
%if ! 0%{?rhel}
%{!?with_check:%global with_check 1}
%else
%{!?with_check:%global with_check 0}
%endif

# Default to skipping autoreconf.  Distros can change just this one line
# (or provide a command-line override) if they backport any patches that
# touch configure.ac or Makefile.am.
%{!?enable_autotools:%global enable_autotools 0}

%global modname engine_db_query

%global commit 0000000000000000000000000000000000000000
%global shortcommit %(c=%{commit}; echo ${c:0:7})

Name:           engine-db-query
Version:        1.6.3
Release:        1%{?release_suffix}%{?dist}
Summary:        A python module to query engine database
License:        GPLv2
Group:          System Environment/Libraries
URL:            https://ovirt.org/

Source0:        https://resources.ovirt.org/pub/src/%{name}/%{name}-%{package_version}.tar.gz

BuildArch:      noarch

%if 0%{?rhel} && 0%{?rhel} < 8
BuildRequires: python3
BuildRequires: python3-rpm-macros
%else
BuildRequires: python3-devel
%endif

# Autotools BuildRequires
%if 0%{?enable_autotools}
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: gettext-devel
BuildRequires: libtool
%endif

%if 0%{?with_check}
BuildRequires: python3-tools
BuildRequires: python3-setuptools
BuildRequires: python3-flake8
%endif

Requires: python3
Requires: python3-psycopg2

%description
python engine-db-query is a python 3 tool and library to manage data from oVirt database

%prep
%setup -q -n %{name}-%{package_version}

%build
%if 0%{?enable_autotools}
autoreconf -if
%endif

%configure

make %{?_smp_mflags}

%install
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%check
%if 0%{?with_check}
make check-local
%endif

%files -n engine-db-query
%license COPYING
%{_bindir}/engine-db-query
%dir %{python3_sitelib}/%{modname}
%{python3_sitelib}/%{modname}/*.py*
%{python3_sitelib}/%{modname}/__pycache__/*.py*
%{_mandir}/man8/*

%changelog
* Wed Apr 21 2021 Sandro Bonazzola <sbonazzo@redhat.com> 1.6.3-1
- Rebase on upstream 1.6.3

* Mon Aug 31 2020 Sandro Bonazzola <sbonazzo@redhat.com> 1.6.2-1
- Rebase on upstream 1.6.2

* Thu Jun 11 2020 Douglas Schilling Landgraf <dougsland@redhat.com> 1.6.1-1
- fix encode for py3

* Mon Feb 24 2020 Sandro Bonazzola <sbonazzo@redhat.com> 1.5.0-1
- Adjust spec file

* Thu Jan 23 2020 Douglas Schilling Landgraf <dougsland@redhat.com> 1.5-0
- Convert project to python3

* Wed May 09 2018 Douglas Schilling Landgraf <dougsland@gmail.com> 1.0-0
- Initial take
