#include <asm-generic/vmlinux.lds.h>
	
OUTPUT_FORMAT(ELF_FORMAT)
OUTPUT_ARCH(ELF_ARCH)
ENTRY(_start)
jiffies = jiffies_64;

SECTIONS
{
  . = START + SIZEOF_HEADERS;

  . = ALIGN(4096);
  __binary_start = .;
  .thread_private : {
    __start_thread_private = .;
    errno = .;
    . += 4;
    arch/um/kernel/unmap_fin.o (.data)
    __end_thread_private = .;
  }
  . = ALIGN(4096);
  .remap : { arch/um/kernel/unmap_fin.o (.text) }

  . = ALIGN(4096);		/* Init code and data */
  _stext = .;
  __init_begin = .;
  .text.init : { *(.text.init) }
  . = ALIGN(4096);
  .text      :
  {
    *(.text)
    /* .gnu.warning sections are handled specially by elf32.em.  */
    *(.gnu.warning)
    *(.gnu.linkonce.t*)
  }

  . = ALIGN(16);		/* Exception table */
  __start___ex_table = .;
  __ex_table : { *(__ex_table) }
  __stop___ex_table = .;

  RODATA

  .fini      : { *(.fini)    } =0x9090
  _etext = .;
  PROVIDE (etext = .);

  . = ALIGN(4096);
  PROVIDE (_sdata = .);

  .unprotected : { *(.unprotected) }
  . = ALIGN(4096);
  PROVIDE (_unprotected_end = .);

  . = ALIGN(4096);
  __uml_setup_start = .;
  .uml.setup.init : { *(.uml.setup.init) }
  __uml_setup_end = .;
	
  __uml_help_start = .;
  .uml.help.init : { *(.uml.help.init) }
  __uml_help_end = .;
	
  __uml_postsetup_start = .;
  .uml.postsetup.init : { *(.uml.postsetup.init) }
  __uml_postsetup_end = .;
	
  __setup_start = .;
  .init.setup : { *(.init.setup) }
  __setup_end = .;

  __start___param = .;
  __param : { *(__param) }
  __stop___param = .;

  __per_cpu_start = . ; 
  .data.percpu : { *(.data.percpu) }
  __per_cpu_end = . ;
	
  __initcall_start = .;
  .initcall.init : {
	*(.initcall1.init) 
	*(.initcall2.init) 
	*(.initcall3.init) 
	*(.initcall4.init) 
	*(.initcall5.init) 
	*(.initcall6.init) 
	*(.initcall7.init)
  }
  __initcall_end = .;
  __uml_initcall_start = .;
  .uml.initcall.init : { *(.uml.initcall.init) }
  __uml_initcall_end = .;
  __init_end = .;
  __exitcall_begin = .;
  .exitcall : { *(.exitcall.exit) }
  __exitcall_end = .;
  __uml_exitcall_begin = .;
  .uml.exitcall : { *(.uml.exitcall.exit) }
  __uml_exitcall_end = .;

   . = ALIGN(4096);
   __initramfs_start = .;
   .init.ramfs : { *(.init.ramfs) }
   __initramfs_end = .;
 
  .data.init : { *(.data.init) }
  .data    :
  {
    . = ALIGN(16384);		/* init_task */
    *(.data.init_task)
    *(.data)
    *(.gnu.linkonce.d*)
    CONSTRUCTORS
  }
  .data1   : { *(.data1) }
  .ctors         :
  {
    *(.ctors)
  }
  .dtors         :
  {
    *(.dtors)
  }

  .got           : { *(.got.plt) *(.got) }
  .dynamic       : { *(.dynamic) }
  /* We want the small data sections together, so single-instruction offsets
     can access them all, and initialized data all before uninitialized, so
     we can shorten the on-disk segment size.  */
  .sdata     : { *(.sdata) }
  _edata  =  .;
  PROVIDE (edata = .);
  . = ALIGN(0x1000);
  .sbss      : 
  {
   __bss_start = .;
   PROVIDE(_bss_start = .);
   *(.sbss) 
   *(.scommon) 
  }
  .bss       :
  {
   *(.dynbss)
   *(.bss)
   *(COMMON)
  }
  _end = . ;
  PROVIDE (end = .);
  /* Stabs debugging sections.  */
  .stab 0 : { *(.stab) }
  .stabstr 0 : { *(.stabstr) }
  .stab.excl 0 : { *(.stab.excl) }
  .stab.exclstr 0 : { *(.stab.exclstr) }
  .stab.index 0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment 0 : { *(.comment) }
}
