/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.attr.AttCertIssuer;
import iaik.x509.attr.AttributeCertificateExtensions;
import iaik.x509.attr.Holder;
import iaik.x509.attr.TargetException;
import iaik.x509.attr.V1Form;
import iaik.x509.attr.V2Form;
import iaik.x509.attr.attributes.AccessIdentity;
import iaik.x509.attr.attributes.ChargingIdentity;
import iaik.x509.attr.attributes.Clearance;
import iaik.x509.attr.attributes.Group;
import iaik.x509.attr.attributes.Role;
import iaik.x509.attr.attributes.ServiceAuthenticationInfo;
import iaik.x509.attr.extensions.ProxyInfo;
import iaik.x509.attr.extensions.TargetInformation;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;

public class AttributeCertificate
extends Certificate
implements X509Extension,
Serializable,
ASN1Type {
    static /* synthetic */ Class m;
    static /* synthetic */ Class n;
    static /* synthetic */ Class o;
    static /* synthetic */ Class p;
    static /* synthetic */ Class q;
    static /* synthetic */ Class r;
    private byte[] k;
    private boolean g;
    private byte[] c;
    private AttributeCertificateExtensions l;
    private BigInteger h;
    private Vector t = new Vector();
    private ChoiceOfTime f;
    private ChoiceOfTime e;
    private BigInteger d;
    private AlgorithmID b;
    private AttCertIssuer i;
    private Holder j;
    private int a = 2;
    private transient ASN1 s = new ASN1();

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.a();
        this.s.writeTo(outputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.toByteArray());
    }

    public void verify(DSAPublicKey dSAPublicKey, DSAParameterSpec dSAParameterSpec) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.a();
        Signature signature = Signature.getInstance("DSA", "IAIK");
        try {
            byte[] byArray = this.s.getFirstObject();
            signature.setParameter("DSAParameterSpec", dSAParameterSpec);
            signature.initVerify(dSAPublicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.c)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey, String string) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.a();
        Signature signature = null;
        signature = string == null ? this.b.getSignatureInstance() : this.b.getSignatureInstance(string);
        try {
            byte[] byArray = this.s.getFirstObject();
            signature.initVerify(publicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.c)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.verify(publicKey, (String)null);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.a + "\n");
        stringBuffer.append("Holder: {" + this.j + "}\n");
        stringBuffer.append("Issuer: {" + this.i + "}\n");
        stringBuffer.append("Signature algorithm: " + this.b + "\n");
        stringBuffer.append("Serial number: " + this.d + "\n");
        stringBuffer.append("Valid not before time: " + this.e + "\n");
        stringBuffer.append("Valid not after  time: " + this.f + "\n");
        stringBuffer.append("Attributes: ");
        if (bl) {
            Enumeration enumeration = this.t.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("\n" + enumeration.nextElement());
            }
        } else {
            stringBuffer.append(this.t.size());
        }
        stringBuffer.append("\n");
        if (this.h != null) {
            stringBuffer.append("Issuer Unique ID: " + this.h + "\n");
        }
        stringBuffer.append("\n");
        if (this.l != null) {
            if (bl) {
                stringBuffer.append(this.l);
            } else {
                stringBuffer.append("Extensions: " + this.l.countExtensions() + "\n");
            }
        }
        stringBuffer.append("Certificate Fingerprint (MD5)  : " + Util.toString(this.getFingerprint()) + "\n");
        stringBuffer.append("Certificate Fingerprint (SHA-1): " + Util.toString(this.getFingerprintSHA()) + "\n");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] toByteArray() {
        this.a();
        return this.s.toByteArray();
    }

    public ASN1Object toASN1Object() {
        this.a();
        return this.s.toASN1Object();
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, String string) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException {
        Object object;
        if (algorithmID == null) {
            throw new CertificateException("Cannot sign certificate! No signature algorithm specified!");
        }
        this.b = algorithmID;
        Signature signature = this.b.getSignatureInstance(string);
        signature.initSign(privateKey);
        try {
            if (!AlgorithmID.getDoNotIncludeParameters(this.b) && !this.b.hasParameters() && (object = signature.getParameter("")) != null && object instanceof AlgorithmParameters) {
                this.b.setAlgorithmParameters((AlgorithmParameters)object);
            }
        }
        catch (Exception exception) {}
        object = this.b();
        try {
            signature.update(DerCoder.encode((ASN1Object)object));
            this.c = signature.sign();
            BIT_STRING bIT_STRING = new BIT_STRING(this.c);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)object);
            sEQUENCE.addComponent(this.b.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.s = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        catch (SignatureException signatureException) {
            throw new CertificateException(signatureException.toString());
        }
        this.d();
        this.e();
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException {
        this.sign(algorithmID, privateKey, null);
    }

    private void e() {
        this.g = false;
    }

    public void setSignatureAlgorithm(AlgorithmID algorithmID) {
        this.b = algorithmID;
        this.d();
    }

    public void setSignature(byte[] byArray) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Cannot sign certificate! No signature value specified!");
        }
        this.c = byArray;
        ASN1Object aSN1Object = this.b();
        try {
            BIT_STRING bIT_STRING = new BIT_STRING(this.c);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.b.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.s = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        this.d();
        this.e();
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.d = bigInteger;
        this.d();
    }

    public void setNotBeforeTime(Date date) {
        this.e = new ChoiceOfTime(date);
        this.e.setEncodingType(ASN.GeneralizedTime);
        this.d();
    }

    public void setNotAfterTime(Date date) {
        this.f = new ChoiceOfTime(date);
        this.f.setEncodingType(ASN.GeneralizedTime);
        this.d();
    }

    private void d() {
        this.g = true;
        this.k = null;
    }

    public void setIssuerUniqueID(boolean[] blArray) {
        this.h = new BigInteger(Util.fromBooleanArray(blArray), 2);
        this.d();
    }

    public void setIssuer(AttCertIssuer attCertIssuer) {
        this.i = attCertIssuer;
        this.d();
    }

    public void setHolder(Holder holder) {
        this.j = holder;
        this.d();
    }

    public void setAttributes(Attribute[] attributeArray) {
        if (attributeArray != null) {
            this.t.removeAllElements();
            int n2 = 0;
            while (n2 < attributeArray.length) {
                this.t.addElement(attributeArray[n2]);
                ++n2;
            }
            this.d();
        }
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        boolean bl2 = bl = this.l == null ? false : this.l.removeExtension(objectID);
        if (bl) {
            this.d();
        }
        return bl;
    }

    public Attribute removeAttribute(ObjectID objectID) {
        if (objectID != null) {
            int n2 = this.t.size();
            int n3 = 0;
            while (n3 < n2) {
                if (objectID.equals(((Attribute)this.t.elementAt(n3)).getType())) {
                    Attribute attribute = (Attribute)this.t.elementAt(n3);
                    this.t.removeElementAt(n3);
                    this.d();
                    return attribute;
                }
                ++n3;
            }
        }
        return null;
    }

    public void removeAllExtensions() {
        if (this.l != null) {
            this.l.removeAllExtensions();
            this.d();
        }
        this.l = null;
    }

    public void removeAllAttributes() {
        this.t.removeAllElements();
        this.d();
    }

    public static void registerStandardAttributeImplementations() {
        Attribute.register(AccessIdentity.oid, r != null ? r : (r = AttributeCertificate.a("iaik.x509.attr.attributes.AccessIdentity")));
        Attribute.register(ChargingIdentity.oid, q != null ? q : (q = AttributeCertificate.a("iaik.x509.attr.attributes.ChargingIdentity")));
        Attribute.register(Clearance.oid, p != null ? p : (p = AttributeCertificate.a("iaik.x509.attr.attributes.Clearance")));
        Attribute.register(Group.oid, o != null ? o : (o = AttributeCertificate.a("iaik.x509.attr.attributes.Group")));
        Attribute.register(Role.oid, n != null ? n : (n = AttributeCertificate.a("iaik.x509.attr.attributes.Role")));
        Attribute.register(ServiceAuthenticationInfo.oid, m != null ? m : (m = AttributeCertificate.a("iaik.x509.attr.attributes.ServiceAuthenticationInfo")));
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        try {
            this.s = new ASN1(objectInputStream);
            this.c();
            return;
        }
        catch (Exception exception) {
            throw new IOException("Unable to restore Certificate: " + exception.toString());
        }
    }

    public Enumeration listExtensions() {
        Enumeration enumeration = null;
        if (this.l != null) {
            Enumeration enumeration2 = this.l.listExtensions();
            if (enumeration2.hasMoreElements()) {
                Vector<V3Extension> vector = new Vector<V3Extension>();
                while (enumeration2.hasMoreElements()) {
                    V3Extension v3Extension = (V3Extension)enumeration2.nextElement();
                    if (v3Extension instanceof ProxyInfo) {
                        ((ProxyInfo)v3Extension).specifyHolder(this.j);
                    }
                    vector.addElement(v3Extension);
                }
                enumeration = vector.elements();
            } else {
                enumeration = enumeration2;
            }
        }
        return enumeration;
    }

    public boolean isTargetFor(Object object) throws TargetException {
        boolean bl = true;
        try {
            TargetInformation targetInformation = (TargetInformation)this.getExtension(TargetInformation.oid);
            bl = targetInformation.isTargetFor(object);
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            throw new TargetException("Error parsing TargetInformation extension: " + x509ExtensionInitException.toString());
        }
        return bl;
    }

    private void c() throws X509ExtensionException, CertificateException {
        int n2 = 0;
        try {
            Object object;
            ASN1Object aSN1Object = this.s.getComponentAt(0);
            AlgorithmID algorithmID = new AlgorithmID(this.s.getComponentAt(1));
            ASN1Object aSN1Object2 = this.s.getComponentAt(2);
            this.c = (byte[])((BIT_STRING)aSN1Object2).getValue();
            ASN1Object aSN1Object3 = aSN1Object.getComponentAt(0);
            if (aSN1Object3.isA(ASN.INTEGER)) {
                object = (BigInteger)aSN1Object3.getValue();
                this.a = ((BigInteger)object).intValue() + 1;
                ++n2;
            } else {
                this.a = 1;
            }
            this.j = new Holder(aSN1Object.getComponentAt(n2));
            aSN1Object3 = aSN1Object.getComponentAt(1 + n2);
            if (aSN1Object3.isA(ASN.CON_SPEC)) {
                object = (CON_SPEC)aSN1Object3;
                ((CON_SPEC)object).forceImplicitlyTagged(ASN.SEQUENCE);
                this.i = new V2Form((ASN1Object)((CON_SPEC)object).getValue());
            } else {
                this.i = new V1Form(aSN1Object3);
            }
            this.b = new AlgorithmID(aSN1Object.getComponentAt(2 + n2));
            if (!algorithmID.equals(this.b)) {
                throw new CertificateException("Certificate signature algorithm mismatch");
            }
            this.d = (BigInteger)aSN1Object.getComponentAt(3 + n2).getValue();
            object = new ASN1(aSN1Object.getComponentAt(4 + n2));
            this.e = new ChoiceOfTime(((ASN1)object).getComponentAt(0));
            this.f = new ChoiceOfTime(((ASN1)object).getComponentAt(1));
            aSN1Object3 = aSN1Object.getComponentAt(5 + n2);
            int n3 = 0;
            while (n3 < aSN1Object3.countComponents()) {
                this.t.addElement(new Attribute(aSN1Object3.getComponentAt(n3)));
                ++n3;
            }
            int n4 = 6 + n2;
            while (n4 < aSN1Object.countComponents()) {
                if ((aSN1Object3 = aSN1Object.getComponentAt(n4++)).isA(ASN.BIT_STRING)) {
                    this.h = new BigInteger(1, (byte[])aSN1Object3.getValue());
                    continue;
                }
                this.l = new AttributeCertificateExtensions(aSN1Object3);
            }
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.getMessage());
        }
        this.s.clearASN1Object();
        this.e();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.l == null) {
            return false;
        }
        return this.l.hasUnsupportedCriticalExtension();
    }

    public boolean hasExtensions() {
        if (this.l == null) {
            return false;
        }
        return this.l.hasExtensions();
    }

    public int getVersion() {
        return this.a;
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.b;
    }

    public byte[] getSignature() {
        return this.c;
    }

    public byte[] getSigAlgParams() {
        if (this.b == null) {
            return null;
        }
        try {
            ASN1Object aSN1Object = this.b.getParameter();
            if (aSN1Object == null) {
                return null;
            }
            return new ASN1(aSN1Object).toByteArray();
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    public String getSigAlgOID() {
        if (this.b == null) {
            return null;
        }
        return this.b.getAlgorithm().getID();
    }

    public String getSigAlgName() {
        if (this.b == null) {
            return null;
        }
        return this.b.getName();
    }

    public BigInteger getSerialNumber() {
        return this.d;
    }

    public PublicKey getPublicKey() {
        return null;
    }

    public Date getNotBeforeTime() {
        if (this.e == null) {
            return null;
        }
        return this.e.getDate();
    }

    public Date getNotAfterTime() {
        if (this.f == null) {
            return null;
        }
        return this.f.getDate();
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.l == null) {
            return null;
        }
        return this.l.getNonCriticalExtensionOIDs();
    }

    public boolean[] getIssuerUniqueID() {
        if (this.h == null) {
            return null;
        }
        String string = this.h.toString(2);
        return Util.toBooleanArray(string);
    }

    public AttCertIssuer getIssuer() {
        return this.i;
    }

    public Holder getHolder() {
        return this.j;
    }

    public byte[] getFingerprintSHA() {
        if (this.k == null) {
            try {
                this.k = this.getFingerprint("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Algorithm SHA not available: " + noSuchAlgorithmException.toString());
            }
        }
        return this.k;
    }

    public byte[] getFingerprint(String string) throws NoSuchAlgorithmException {
        this.a();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(this.toByteArray());
        return messageDigest.digest();
    }

    public byte[] getFingerprint() {
        this.a();
        return this.s.fingerprint();
    }

    public byte[] getExtensionValue(String string) {
        if (this.l == null) {
            return null;
        }
        return this.l.getExtensionValue(string);
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        V3Extension v3Extension = null;
        if (this.l != null && (v3Extension = this.l.getExtension(objectID)) instanceof ProxyInfo) {
            ((ProxyInfo)v3Extension).specifyHolder(this.j);
        }
        return v3Extension;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        this.a();
        return this.toByteArray();
    }

    public Set getCriticalExtensionOIDs() {
        if (this.l == null) {
            return null;
        }
        return this.l.getCriticalExtensionOIDs();
    }

    public Enumeration getAttributes() {
        return this.t.elements();
    }

    public Attribute getAttribute(ObjectID objectID) {
        if (this.t == null) {
            return null;
        }
        Enumeration enumeration = this.t.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.getType().equals(objectID)) continue;
            return attribute;
        }
        return null;
    }

    public byte[] getAcInfo() throws CertificateEncodingException {
        try {
            if (this.s != null && this.s.toByteArray() != null) {
                return this.s.getFirstObject();
            }
            return DerCoder.encode(this.b());
        }
        catch (CodingException codingException) {
            throw new CertificateEncodingException(codingException.toString());
        }
    }

    public void decode(InputStream inputStream) throws CertificateException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("Cannot parse certificate from a null input stream!");
        }
        try {
            this.s = new ASN1(inputStream);
            this.c();
            return;
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CertificateException(x509ExtensionException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot parse certificate from a null object!");
        }
        this.s = new ASN1(aSN1Object);
        try {
            this.c();
            return;
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    private ASN1Object b() throws CertificateEncodingException {
        if (this.j == null) {
            throw new CertificateEncodingException("Holder not set!");
        }
        if (this.i == null) {
            throw new CertificateEncodingException("Issuer not set!");
        }
        if (this.b == null) {
            throw new CertificateEncodingException("Signature algorithm not set!");
        }
        if (this.d == null) {
            throw new CertificateEncodingException("Serial number not set!");
        }
        if (this.e == null) {
            throw new CertificateEncodingException("Valid not before time not set!");
        }
        if (this.f == null) {
            throw new CertificateEncodingException("Valid not after time not set!");
        }
        if (this.t.isEmpty()) {
            throw new CertificateEncodingException("No Attributes set!");
        }
        if (this.l != null && !this.l.hasExtensions()) {
            this.l = null;
        }
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            if (this.a > 1) {
                sEQUENCE.addComponent(new INTEGER(this.a - 1));
            }
            sEQUENCE.addComponent(this.j.toASN1Object());
            boolean bl = true;
            if (this.i.getVForm() == 1) {
                sEQUENCE.addComponent(this.i.toASN1Object());
            } else {
                sEQUENCE.addComponent(new CON_SPEC(0, this.i.toASN1Object(), bl));
            }
            sEQUENCE.addComponent(this.b.toASN1Object());
            sEQUENCE.addComponent(new INTEGER(this.d));
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(this.e.toASN1Object());
            sEQUENCE2.addComponent(this.f.toASN1Object());
            sEQUENCE.addComponent(sEQUENCE2);
            SEQUENCE sEQUENCE3 = new SEQUENCE();
            Enumeration enumeration = this.t.elements();
            while (enumeration.hasMoreElements()) {
                sEQUENCE3.addComponent(((Attribute)enumeration.nextElement()).toASN1Object(true));
            }
            sEQUENCE.addComponent(sEQUENCE3);
            if (this.h != null) {
                BIT_STRING bIT_STRING = new BIT_STRING(this.h.toByteArray());
                sEQUENCE.addComponent(bIT_STRING);
            }
            if (this.l != null) {
                sEQUENCE.addComponent(this.l.toASN1Object());
            }
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new CertificateEncodingException(exception.toString());
        }
    }

    public int countExtensions() {
        if (this.l == null) {
            return 0;
        }
        return this.l.countExtensions();
    }

    public void checkValidity(Date date) throws CertificateNotYetValidException, CertificateExpiredException {
        if (this.e == null) {
            throw new CertificateNotYetValidException("ValidNotBefore date not set!");
        }
        if (date.before(this.e.getDate())) {
            throw new CertificateNotYetValidException();
        }
        if (this.f == null) {
            throw new CertificateExpiredException("ValidNotAfter date not set!");
        }
        if (date.after(this.f.getDate())) {
            throw new CertificateExpiredException();
        }
    }

    public void checkValidity() throws CertificateNotYetValidException, CertificateExpiredException {
        this.checkValidity(new Date());
    }

    private void a() {
        if (this.g) {
            throw new RuntimeException("Cannot perform operation, certificate has to be signed first");
        }
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.l == null) {
            this.l = new AttributeCertificateExtensions();
        }
        if (v3Extension instanceof ProxyInfo) {
            ((ProxyInfo)v3Extension).specifyHolder(this.j);
        }
        this.l.addExtension(v3Extension);
        this.d();
    }

    public void addAttribute(Attribute attribute) {
        if (attribute != null) {
            this.d();
            int n2 = this.t.size();
            int n3 = 0;
            while (n3 < n2) {
                if (attribute.getType().equals(((Attribute)this.t.elementAt(n3)).getType())) {
                    this.t.setElementAt(attribute, n3);
                    return;
                }
                ++n3;
            }
            this.t.addElement(attribute);
        }
    }

    public AttributeCertificate(byte[] byArray) throws CertificateException {
        this();
        if (byArray == null) {
            throw new NullPointerException("Cannot parse certificate from a null byte array!");
        }
        try {
            this.s = new ASN1(byArray);
            this.c();
            return;
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.getMessage());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CertificateException(x509ExtensionException.getMessage());
        }
    }

    public AttributeCertificate(InputStream inputStream) throws CertificateException, IOException {
        this();
        if (inputStream == null) {
            throw new NullPointerException("Cannot parse certificate from a null input stream!");
        }
        this.decode(inputStream);
    }

    public AttributeCertificate() {
        super("X.509 AC");
        this.d();
    }

    static {
        AttributeCertificate.registerStandardAttributeImplementations();
    }
}

