/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public abstract class DelegatingLabelProviderWithTooltip
extends ColumnLabelProvider {
    private final ILabelDecorator decorator;
    ILabelProvider wrappedLabelProvider;

    DelegatingLabelProviderWithTooltip(ILabelProvider wrappedLabelProvider, ILabelDecorator decorator) {
        this.wrappedLabelProvider = wrappedLabelProvider;
        this.decorator = decorator;
        wrappedLabelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                DelegatingLabelProviderWithTooltip.this.fireLabelProviderChanged(event);
            }
        });
    }

    protected void initialize(ColumnViewer viewer, ViewerColumn column) {
        super.initialize(viewer, column);
        if (this.decorator != null) {
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        }
    }

    protected void fireLabelProviderChanged(LabelProviderChangedEvent event) {
        super.fireLabelProviderChanged(event);
    }

    public String getText(Object element) {
        return this.wrappedLabelProvider.getText(element);
    }

    public Image getImage(Object element) {
        return this.wrappedLabelProvider.getImage(element);
    }

    public Font getFont(Object element) {
        if (this.wrappedLabelProvider instanceof IFontProvider) {
            return ((IFontProvider)this.wrappedLabelProvider).getFont(element);
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (this.wrappedLabelProvider instanceof IColorProvider) {
            return ((IColorProvider)this.wrappedLabelProvider).getForeground(element);
        }
        return null;
    }

    public Color getBackground(Object element) {
        if (this.wrappedLabelProvider instanceof IColorProvider) {
            return ((IColorProvider)this.wrappedLabelProvider).getBackground(element);
        }
        return null;
    }

    public String getToolTipText(Object element) {
        if (this.decorator == null) {
            return null;
        }
        String text = this.getText(element);
        element = this.unwrapElement(element);
        return this.decorator.decorateText(text, element);
    }

    protected abstract Object unwrapElement(Object var1);

    public void dispose() {
        this.wrappedLabelProvider.dispose();
        super.dispose();
    }
}

