/*
 * Decompiled with CFR 0.152.
 */
package demo.smime.ess;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import demo.smime.DumpMessage;
import iaik.asn1.structures.AlgorithmID;
import iaik.smime.CryptoContent;
import iaik.smime.EncryptedContent;
import iaik.smime.SMimeBodyPart;
import iaik.smime.SMimeMultipart;
import iaik.smime.SignedContent;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class TripleWrapping {
    PrivateKey signerPrivateKey2;
    X509Certificate signerCertificate2;
    X509Certificate[] signerCertificates2;
    PrivateKey signerPrivateKey1;
    X509Certificate encryptionCertOfSigner1;
    X509Certificate signerCertificate1;
    X509Certificate recipientCertificate;
    X509Certificate[] signerCertificates1;
    String host = "mailhost";
    String from = "smimetest@iaik.at";
    String to = "smimetest@iaik.at";
    String lastName = "SMime";
    String firstName = "John";
    static final boolean b = false;
    static final boolean a = false;

    public Message tripleWrap(Session session, DataHandler dataHandler, boolean bl, boolean bl2, boolean bl3) throws Exception {
        Message message;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "IAIK-S/MIME: TripleWrapped:  ";
        stringBuffer.append("This is a triple wrapped message where  ");
        if (bl) {
            string = String.valueOf(string) + "implicit signed - encrypted - ";
            stringBuffer.append("the inner content is implicit signed\n");
        } else {
            string = String.valueOf(string) + "explicit signed - encrypted - ";
            stringBuffer.append("the inner content is explicit signed\n");
        }
        if (bl2) {
            string = String.valueOf(string) + "implicit signed";
            stringBuffer.append("and the outer content is implicit signed\n");
        } else {
            string = String.valueOf(string) + "explicit signed";
            stringBuffer.append("and the outer content is explicit signed\n");
        }
        Message message2 = this.createMessage(session, string);
        SignedContent signedContent = new SignedContent(bl);
        if (dataHandler != null) {
            signedContent.setDataHandler(dataHandler);
        } else {
            signedContent.setText(stringBuffer.toString());
        }
        signedContent.setCertificates((Certificate[])this.signerCertificates1);
        try {
            signedContent.addSigner((PrivateKey)((RSAPrivateKey)this.signerPrivateKey1), this.signerCertificate1);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MessagingException("Algorithm not supported: " + noSuchAlgorithmException.getMessage(), (Exception)noSuchAlgorithmException);
        }
        EncryptedContent encryptedContent = new EncryptedContent((CryptoContent)signedContent);
        encryptedContent.setSMimeType();
        encryptedContent.addRecipient(this.recipientCertificate, AlgorithmID.rsaEncryption);
        encryptedContent.addRecipient(this.encryptionCertOfSigner1, AlgorithmID.rsaEncryption);
        encryptedContent.setEncryptionAlgorithm((AlgorithmID)AlgorithmID.des_EDE3_CBC.clone(), 192);
        if (bl3) {
            message = this.createMessage(session, "IAIK-S/MIME: Signed and encrypted");
            message.setContent((Object)encryptedContent, encryptedContent.getContentType());
            encryptedContent.setHeaders((Part)message);
            message.saveChanges();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            message.writeTo((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            message.writeTo((OutputStream)System.out);
            DumpMessage.dump(message);
            encryptedContent = (EncryptedContent)message.getContent();
        }
        message = new SignedContent((CryptoContent)encryptedContent, bl2);
        if (bl3) {
            message.setCertificates((Certificate[])this.signerCertificates2);
            try {
                message.addSigner((PrivateKey)((RSAPrivateKey)this.signerPrivateKey2), this.signerCertificate2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new MessagingException("Algorithm not supported: " + noSuchAlgorithmException.getMessage(), (Exception)noSuchAlgorithmException);
            }
        }
        message.setCertificates((Certificate[])this.signerCertificates1);
        try {
            message.addSigner((PrivateKey)((RSAPrivateKey)this.signerPrivateKey1), this.signerCertificate1);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MessagingException("Algorithm not supported: " + noSuchAlgorithmException.getMessage(), (Exception)noSuchAlgorithmException);
        }
        message2.setContent((Object)message, message.getContentType());
        message.setHeaders((Part)message2);
        message2.saveChanges();
        return message2;
    }

    public void start() throws IOException {
        Session session = DemoUtil.getSession();
        try {
            SMimeBodyPart sMimeBodyPart = new SMimeBodyPart();
            sMimeBodyPart.setText("This is a Test of the IAIK S/MIME implementation!\n\n");
            SMimeBodyPart sMimeBodyPart2 = new SMimeBodyPart();
            sMimeBodyPart2.setDataHandler(new DataHandler((DataSource)new FileDataSource("test.html")));
            sMimeBodyPart2.setFileName("test.html");
            SMimeMultipart sMimeMultipart = new SMimeMultipart();
            sMimeMultipart.addBodyPart((BodyPart)sMimeBodyPart);
            sMimeMultipart.addBodyPart((BodyPart)sMimeBodyPart2);
            DataHandler dataHandler = new DataHandler((Object)sMimeMultipart, sMimeMultipart.getContentType());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            System.out.println("1. implicitly signed - encrypted - implicitly signed; inner = outer signed");
            Message message = this.tripleWrap(session, dataHandler, true, true, false);
            message.writeTo((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            byteArrayOutputStream.reset();
            System.out.println("\n\n*****************************************\n\n");
            System.out.println("2. implicitly signed - encrypted - implicitly signed; inner != outer signed");
            message = this.tripleWrap(session, dataHandler, true, true, true);
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            byteArrayOutputStream.reset();
            System.out.println("\n\n*****************************************\n\n");
            System.out.println("3. implicitly signed - encrypted - explicitly signed; inner = outer signed");
            message = this.tripleWrap(session, dataHandler, true, false, false);
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            byteArrayOutputStream.reset();
            System.out.println("\n\n*****************************************\n\n");
            System.out.println("4. implicitly signed - encrypted - explicitly signed; inner != outer signed");
            message = this.tripleWrap(session, dataHandler, true, false, true);
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            byteArrayOutputStream.reset();
            System.out.println("\n\n*****************************************\n\n");
            System.out.println("5. explicitly signed - encrypted - implicitly signed; inner = outer signed");
            message = this.tripleWrap(session, dataHandler, false, true, false);
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            byteArrayOutputStream.reset();
            System.out.println("\n\n*****************************************\n\n");
            System.out.println("6. explicitly signed - encrypted - implicitly signed; inner != outer signed");
            message = this.tripleWrap(session, dataHandler, false, true, true);
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            byteArrayOutputStream.reset();
            System.out.println("\n\n*****************************************\n\n");
            System.out.println("7. explicitly signed - encrypted - explicitly signed; inner = outer signed");
            message = this.tripleWrap(session, dataHandler, false, false, false);
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            byteArrayOutputStream.reset();
            System.out.println("\n\n*****************************************\n\n");
            System.out.println("8. explicitly signed - encrypted - explicitly signed; inner != outer signed");
            message = this.tripleWrap(session, dataHandler, false, false, true);
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            byteArrayOutputStream.reset();
            System.out.println("\n\n*****************************************\n\n");
            System.out.println("Ready!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
        System.out.println("OK!");
    }

    public static void main(String[] stringArray) throws IOException {
        DemoUtil.initSMimeDemos();
        new TripleWrapping().start();
        Util.waitKey();
    }

    public Message createMessage(Session session, String string) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(this.from));
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to, (boolean)false));
        mimeMessage.setSentDate(new Date());
        mimeMessage.setSubject(string);
        return mimeMessage;
    }

    public TripleWrapping() {
        PrivateKey privateKey;
        System.out.println();
        System.out.println("******************************************************************************************");
        System.out.println("*                             TripleWrapping demo                                        *");
        System.out.println("* (shows the usage of the IAIK-CMS library for creating/parsing a triple wrapped message *");
        System.out.println("******************************************************************************************");
        System.out.println();
        this.signerCertificates1 = CMSKeyStore.getCertificateChain(0, 1);
        this.signerPrivateKey1 = CMSKeyStore.getPrivateKey(0, 1);
        this.signerCertificate1 = this.signerCertificates1[0];
        this.recipientCertificate = CMSKeyStore.getCertificateChain(0, 5)[0];
        DumpMessage.privateKey = privateKey = CMSKeyStore.getPrivateKey(0, 5);
        this.encryptionCertOfSigner1 = CMSKeyStore.getCertificateChain(0, 4)[0];
        this.signerCertificates2 = CMSKeyStore.getCertificateChain(0, 0);
        this.signerPrivateKey2 = CMSKeyStore.getPrivateKey(0, 0);
        this.signerCertificate2 = this.signerCertificates2[0];
    }
}

