/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl.dom.properties;

import iaik.x509.X509CRL;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.CRLNumber;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.DigestMethodImpl;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.URIDereferencerImpl;
import iaik.xml.crypto.xades.CRLIdentifier;
import iaik.xml.crypto.xades.CRLRef;
import iaik.xml.crypto.xades.DigestAlgAndValue;
import iaik.xml.crypto.xades.dom.XadesDOMStructure;
import iaik.xml.crypto.xades.impl.dom.properties.CRLIdentifierImpl;
import iaik.xml.crypto.xades.impl.dom.properties.DigestAlgAndValueImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CRLRefImpl
extends XadesDOMStructure
implements CRLRef {
    private byte[] d;
    private InputStream a;
    private DigestAlgAndValueImpl b;
    private CRLIdentifierImpl c;

    public boolean validate(XMLCryptoContext xMLCryptoContext, Data data) throws XMLSignatureException {
        if (xMLCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null.");
        }
        if (data != null || this.d == null) {
            List list = DOMUtils.distributeNSDeclarations((Element)((Element)this.getNode()));
            if (data == null) {
                data = this.a(xMLCryptoContext);
            }
            if (!(data instanceof OctetStreamData)) {
                throw new XMLSignatureException("Failed to calculate crl digest. Digest input must be octets.");
            }
            try {
                this.d = this.b.calculateDigestValue(((OctetStreamData)data).getOctetStream(), xMLCryptoContext);
            }
            catch (IOException iOException) {
                throw new XMLSignatureException("Failed to calculate certificate digest.", iOException);
            }
            DOMUtils.withdrawDistributedNSDeclarations((Element)((Element)this.getNode()), (List)list);
        }
        return this.b.getDigestValue() != null ? Arrays.equals(this.b.getDigestValue(), this.d) : false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.getLocalName()) + ":\n");
        stringBuffer.append(this.getCRLIdentifier());
        stringBuffer.append(this.getDigestAlgAndValue());
        return stringBuffer.toString();
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof DigestAlgAndValueImpl) {
            this.b = (DigestAlgAndValueImpl)dOMStructure;
            return;
        }
        if (dOMStructure instanceof CRLIdentifierImpl) {
            this.c = (CRLIdentifierImpl)dOMStructure;
        }
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        if (this.b.getDigestValue() == null) {
            try {
                InputStream inputStream = this.a;
                if (inputStream == null) {
                    Data data = this.a(dOMCryptoContext);
                    if (!(data instanceof OctetStreamData)) {
                        throw new MarshalException("Failed to calculate CRL digest. Digest input must be octets.");
                    }
                    inputStream = ((OctetStreamData)data).getOctetStream();
                }
                this.b.calculateAndAppendDigestValue(dOMCryptoContext, inputStream);
            }
            catch (XMLSignatureException xMLSignatureException) {
                throw new MarshalException("Failed to calculate CRL digest.", xMLSignatureException);
            }
            catch (IOException iOException) {
                throw new MarshalException("Failed to calculate CRL digest.", iOException);
            }
        }
        return node3;
    }

    public String getLocalName() {
        return "CRLRef";
    }

    private Data a(XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        URIDereferencer uRIDereferencer;
        URIDereferencer uRIDereferencer2 = uRIDereferencer = xMLCryptoContext.getURIDereferencer() != null ? xMLCryptoContext.getURIDereferencer() : new URIDereferencerImpl();
        if (uRIDereferencer == null) {
            throw new XMLSignatureException("No URIDereferencer set in provider");
        }
        try {
            return uRIDereferencer.dereference(this.c, xMLCryptoContext);
        }
        catch (URIReferenceException uRIReferenceException) {
            throw new XMLSignatureException("Failed to dereference URI '" + this.c.getURI() + "'. ", uRIReferenceException);
        }
    }

    public DigestAlgAndValue getDigestAlgAndValue() {
        return this.b;
    }

    protected List getChildStructures() {
        List list = super.getChildStructures();
        list.add(this.b);
        if (this.c != null) {
            list.add(this.c);
        }
        return list;
    }

    public CRLIdentifier getCRLIdentifier() {
        return this.c;
    }

    public CRLRefImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.c == null || this.b == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public CRLRefImpl(java.security.cert.X509CRL x509CRL, DigestMethodImpl digestMethodImpl, String string) {
        if (x509CRL == null) {
            throw new NullPointerException("Argument 'x509CRL' must not be null");
        }
        try {
            String string2 = x509CRL.getIssuerDN().toString();
            Date date = x509CRL.getThisUpdate();
            BigInteger bigInteger = null;
            X509CRL x509CRL2 = x509CRL instanceof X509CRL ? (X509CRL)x509CRL : new X509CRL(x509CRL.getEncoded());
            CRLNumber cRLNumber = (CRLNumber)x509CRL2.getExtension(CRLNumber.oid);
            if (cRLNumber != null) {
                bigInteger = cRLNumber.getCRLNumber();
            }
            this.c = new CRLIdentifierImpl(string2, date, bigInteger, string);
            this.a = new ByteArrayInputStream(x509CRL.getEncoded());
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            throw new IllegalArgumentException("Argument 'x509CRL' invalid. " + x509ExtensionInitException.getMessage());
        }
        catch (CRLException cRLException) {
            throw new IllegalArgumentException("Argument 'x509CRL' invalid. " + cRLException.getMessage());
        }
        if (digestMethodImpl == null) {
            throw new NullPointerException("Argument 'digestMethod' must not be null.");
        }
        this.b = new DigestAlgAndValueImpl(digestMethodImpl);
    }

    public CRLRefImpl(CRLIdentifierImpl cRLIdentifierImpl, DigestAlgAndValueImpl digestAlgAndValueImpl) {
        if (cRLIdentifierImpl == null) {
            throw new NullPointerException("Argument 'crlIdentifier' must not be null.");
        }
        this.c = cRLIdentifierImpl;
        if (digestAlgAndValueImpl == null) {
            throw new NullPointerException("Argument 'digestAlgAndValue' must not be null.");
        }
        this.b = digestAlgAndValueImpl;
    }

    public CRLRefImpl(CRLIdentifierImpl cRLIdentifierImpl, DigestMethodImpl digestMethodImpl, InputStream inputStream) {
        if (cRLIdentifierImpl == null) {
            throw new NullPointerException("Argument 'crlIdentifier' must not be null.");
        }
        this.c = cRLIdentifierImpl;
        if (digestMethodImpl == null) {
            throw new NullPointerException("Argument 'digestMethod' must not be null.");
        }
        this.b = new DigestAlgAndValueImpl(digestMethodImpl);
        if (inputStream == null) {
            throw new NullPointerException("Argument 'digestInputStream' must not be null.");
        }
        this.a = inputStream;
    }
}

