/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.campi;

import finanze.IDTE.studi2002.campi.ControlloFormaleException;
import finanze.IDTE.studi2002.campi.NumericModel;

public class RangeNumericModel
extends NumericModel {
    private long minValue = Long.MIN_VALUE;
    private long maxValue = Long.MAX_VALUE;
    private long valorePredefinito;

    public RangeNumericModel(String code, String errorDescription, int length, long minValue, long maxValue) {
        super(code, errorDescription, length);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valorePredefinito = minValue;
        this.setValorePredefinito();
    }

    public String getValorePredefinito() {
        return String.valueOf(this.valorePredefinito);
    }

    public boolean isValorePredefinito() {
        return this.getNumericValue() == this.valorePredefinito;
    }

    public void setValore(String s) throws ControlloFormaleException {
        if (!this.isNumeric(s)) {
            this.errore = "011";
            this.gravitaErrore = "scarto";
            throw new ControlloFormaleException(s);
        }
        if (s.length() > this.length()) {
            this.errore = "020";
            this.gravitaErrore = "scarto";
            throw new ControlloFormaleException(s);
        }
        this.valore = s;
        if (this.getNumericValue() < this.minValue || this.getNumericValue() > this.maxValue) {
            this.setValorePredefinito();
            this.errore = "012";
            this.gravitaErrore = "scarto_confermabile";
            throw new ControlloFormaleException(s);
        }
    }

    public void setValorePredefinito() {
        this.valore = String.valueOf(this.valorePredefinito);
    }
}

