/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.pbe;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;

public class PBEParameters
extends AlgorithmParametersSpi {
    private int b = 1;
    private byte[] a;

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("salt: " + Util.toString(this.a) + "\n");
        stringBuffer.append("iteration count: " + this.b + "\n");
        return stringBuffer.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            this.a = (byte[])aSN1Object.getComponentAt(0).getValue();
            if (aSN1Object.countComponents() == 2) {
                this.b = ((BigInteger)aSN1Object.getComponentAt(1).getValue()).intValue();
                return;
            }
        }
        catch (CodingException codingException) {
            throw new IOException("DER decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof PBEParameterSpec) {
            this.a = ((PBEParameterSpec)algorithmParameterSpec).getSalt();
            this.b = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
            return;
        }
        if (algorithmParameterSpec instanceof PBEKeyAndParameterSpec) {
            this.a = ((PBEKeyAndParameterSpec)algorithmParameterSpec).getSalt();
            this.b = ((PBEKeyAndParameterSpec)algorithmParameterSpec).getIterationCount();
            return;
        }
        throw new InvalidParameterSpecException("Parameter must be PBEParameterSpec.");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.a, this.b);
        if (!pBEParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return pBEParameterSpec;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new OCTET_STRING(this.a));
        sEQUENCE.addComponent(new INTEGER(BigInteger.valueOf(this.b)));
        return DerCoder.encode(sEQUENCE);
    }
}

