/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.PKCS1AlgorithmParameters;
import iaik.pkcs.pkcs1.RSAOaepPSourceParameterSpec;
import iaik.pkcs.pkcs1.RSAOaepParameterSpec;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class RSAOaepParameters
extends PKCS1AlgorithmParameters {
    private RSAOaepParameterSpec a;
    private static boolean b;

    public ASN1Object toASN1Object() {
        if (this.a == null) {
            throw new NullPointerException("Cannot encode null params!");
        }
        AlgorithmID algorithmID = this.a.getHashAlgorithm();
        AlgorithmID algorithmID2 = this.a.getMaskGenAlgorithm();
        AlgorithmID algorithmID3 = this.a.getPSourceAlgorithm();
        Boolean bl = this.a.getEncodeDefaultValues();
        boolean bl2 = bl != null ? bl : b;
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (algorithmID != null && (bl2 || !algorithmID.equals(RSAOaepParameterSpec.DEFAULT_HASH_ALGORITHM))) {
            sEQUENCE.addComponent(new CON_SPEC(0, algorithmID.toASN1Object()));
        }
        if (algorithmID2 != null) {
            ASN1Object aSN1Object = null;
            ASN1Object aSN1Object2 = algorithmID2.getParameter();
            if (aSN1Object2 != null && aSN1Object2.isA(ASN.SEQUENCE)) {
                try {
                    aSN1Object = aSN1Object2.getComponentAt(0);
                }
                catch (CodingException codingException) {}
            }
            if (bl2 || !algorithmID2.equals(RSAOaepParameterSpec.DEFAULT_MASK_GEN_ALGORITHM) || !RSAOaepParameterSpec.DEFAULT_HASH_ALGORITHM.getAlgorithm().equals(aSN1Object)) {
                sEQUENCE.addComponent(new CON_SPEC(1, algorithmID2.toASN1Object()));
            }
        }
        if (!(algorithmID3 == null || !bl2 && algorithmID3.equals(RSAOaepPSourceParameterSpec.DEFAULT_PSOURCE_ALGORITHM) && RSAOaepPSourceParameterSpec.DEFAULT_PSOURCE_ALGORITHM.getParameter().equals(algorithmID3.getParameter()))) {
            sEQUENCE.addComponent(new CON_SPEC(2, algorithmID3.toASN1Object()));
        }
        return sEQUENCE;
    }

    public static void setEncodeDefaultValues(boolean bl) {
        b = bl;
    }

    public static boolean getEncodeDefaultValues() {
        return b;
    }

    protected String engineToString() {
        if (this.a == null) {
            return "";
        }
        return this.a.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.decode(DerCoder.decode(byArray));
            return;
        }
        catch (CodingException codingException) {
            throw new IOException("Parsing error: " + codingException.toString());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        this.a = null;
        if (algorithmParameterSpec instanceof RSAOaepParameterSpec) {
            this.a = (RSAOaepParameterSpec)((RSAOaepParameterSpec)algorithmParameterSpec).clone();
            return;
        }
        throw new InvalidParameterSpecException("Parameter must be a RSAOaepParameterSpec.");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        RSAOaepParameterSpec rSAOaepParameterSpec = null;
        if (this.a != null) {
            if (!this.a.getClass().isAssignableFrom(clazz)) {
                try {
                    Class<?> clazz2 = Class.forName("iaik.pkcs.pkcs1.PKCS1AlgorithmParameterSpec");
                    if (!clazz.isAssignableFrom(clazz2)) {
                        throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
                }
            }
            rSAOaepParameterSpec = (RSAOaepParameterSpec)this.a.clone();
        }
        return rSAOaepParameterSpec;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() throws IOException {
        return DerCoder.encode(this.toASN1Object());
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a = null;
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid OAEP parameter encoding. Expected ASN.1 SEQUENCE!");
        }
        AlgorithmID algorithmID = null;
        AlgorithmID algorithmID2 = null;
        AlgorithmID algorithmID3 = null;
        int n2 = 0;
        while (n2 < aSN1Object.countComponents()) {
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(n2);
            int n3 = cON_SPEC.getAsnType().getTag();
            switch (n3) {
                case 0: {
                    algorithmID = new AlgorithmID((ASN1Object)cON_SPEC.getValue());
                    break;
                }
                case 1: {
                    algorithmID2 = new AlgorithmID((ASN1Object)cON_SPEC.getValue());
                    break;
                }
                case 2: {
                    algorithmID3 = new AlgorithmID((ASN1Object)cON_SPEC.getValue());
                    break;
                }
                default: {
                    throw new CodingException("Invalid tagged (" + n3 + ") in OAEP parameter component number " + n2 + ".");
                }
            }
            ++n2;
        }
        if (algorithmID == null) {
            algorithmID = RSAOaepParameterSpec.DEFAULT_HASH_ALGORITHM;
        }
        if (algorithmID2 == null) {
            algorithmID2 = RSAOaepParameterSpec.DEFAULT_MASK_GEN_ALGORITHM;
        }
        if (algorithmID3 == null) {
            algorithmID3 = RSAOaepPSourceParameterSpec.DEFAULT_PSOURCE_ALGORITHM;
        }
        this.a = new RSAOaepParameterSpec(algorithmID, algorithmID2, algorithmID3);
    }
}

