/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy;

import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMapKey;
import com.sun.xml.internal.ws.policy.PolicyMapKeyHandler;
import com.sun.xml.internal.ws.policy.PolicyMapMutator;
import com.sun.xml.internal.ws.policy.PolicyMerger;
import com.sun.xml.internal.ws.policy.PolicyScope;
import com.sun.xml.internal.ws.policy.PolicySubject;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;

public final class PolicyMap
implements Iterable<Policy> {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyMap.class);
    private static final PolicyMapKeyHandler serviceKeyHandler = new PolicyMapKeyHandler(){

        @Override
        public boolean areEqual(PolicyMapKey policyMapKey, PolicyMapKey policyMapKey2) {
            return policyMapKey.getService().equals(policyMapKey2.getService());
        }

        @Override
        public int generateHashCode(PolicyMapKey policyMapKey) {
            int n = 17;
            n = 37 * n + policyMapKey.getService().hashCode();
            return n;
        }
    };
    private static final PolicyMapKeyHandler endpointKeyHandler = new PolicyMapKeyHandler(){

        @Override
        public boolean areEqual(PolicyMapKey policyMapKey, PolicyMapKey policyMapKey2) {
            boolean bl = true;
            boolean bl2 = bl = bl && policyMapKey.getService().equals(policyMapKey2.getService());
            bl = bl && (policyMapKey.getPort() == null ? policyMapKey2.getPort() == null : policyMapKey.getPort().equals(policyMapKey2.getPort()));
            return bl;
        }

        @Override
        public int generateHashCode(PolicyMapKey policyMapKey) {
            int n = 17;
            n = 37 * n + policyMapKey.getService().hashCode();
            n = 37 * n + (policyMapKey.getPort() == null ? 0 : policyMapKey.getPort().hashCode());
            return n;
        }
    };
    private static final PolicyMapKeyHandler operationAndInputOutputMessageKeyHandler = new PolicyMapKeyHandler(){

        @Override
        public boolean areEqual(PolicyMapKey policyMapKey, PolicyMapKey policyMapKey2) {
            boolean bl = true;
            boolean bl2 = bl = bl && policyMapKey.getService().equals(policyMapKey2.getService());
            boolean bl3 = bl && (policyMapKey.getPort() == null ? policyMapKey2.getPort() == null : policyMapKey.getPort().equals(policyMapKey2.getPort())) ? true : (bl = false);
            bl = bl && (policyMapKey.getOperation() == null ? policyMapKey2.getOperation() == null : policyMapKey.getOperation().equals(policyMapKey2.getOperation()));
            return bl;
        }

        @Override
        public int generateHashCode(PolicyMapKey policyMapKey) {
            int n = 17;
            n = 37 * n + policyMapKey.getService().hashCode();
            n = 37 * n + (policyMapKey.getPort() == null ? 0 : policyMapKey.getPort().hashCode());
            n = 37 * n + (policyMapKey.getOperation() == null ? 0 : policyMapKey.getOperation().hashCode());
            return n;
        }
    };
    private static final PolicyMapKeyHandler faultMessageHandler = new PolicyMapKeyHandler(){

        @Override
        public boolean areEqual(PolicyMapKey policyMapKey, PolicyMapKey policyMapKey2) {
            boolean bl = true;
            boolean bl2 = bl = bl && policyMapKey.getService().equals(policyMapKey2.getService());
            boolean bl3 = bl && (policyMapKey.getPort() == null ? policyMapKey2.getPort() == null : policyMapKey.getPort().equals(policyMapKey2.getPort())) ? true : (bl = false);
            boolean bl4 = bl && (policyMapKey.getOperation() == null ? policyMapKey2.getOperation() == null : policyMapKey.getOperation().equals(policyMapKey2.getOperation())) ? true : (bl = false);
            bl = bl && (policyMapKey.getFaultMessage() == null ? policyMapKey2.getFaultMessage() == null : policyMapKey.getFaultMessage().equals(policyMapKey2.getFaultMessage()));
            return bl;
        }

        @Override
        public int generateHashCode(PolicyMapKey policyMapKey) {
            int n = 17;
            n = 37 * n + policyMapKey.getService().hashCode();
            n = 37 * n + (policyMapKey.getPort() == null ? 0 : policyMapKey.getPort().hashCode());
            n = 37 * n + (policyMapKey.getOperation() == null ? 0 : policyMapKey.getOperation().hashCode());
            n = 37 * n + (policyMapKey.getFaultMessage() == null ? 0 : policyMapKey.getFaultMessage().hashCode());
            return n;
        }
    };
    private static final PolicyMerger merger = PolicyMerger.getMerger();
    private final ScopeMap serviceMap = new ScopeMap(merger, serviceKeyHandler);
    private final ScopeMap endpointMap = new ScopeMap(merger, endpointKeyHandler);
    private final ScopeMap operationMap = new ScopeMap(merger, operationAndInputOutputMessageKeyHandler);
    private final ScopeMap inputMessageMap = new ScopeMap(merger, operationAndInputOutputMessageKeyHandler);
    private final ScopeMap outputMessageMap = new ScopeMap(merger, operationAndInputOutputMessageKeyHandler);
    private final ScopeMap faultMessageMap = new ScopeMap(merger, faultMessageHandler);

    private PolicyMap() {
    }

    public static PolicyMap createPolicyMap(Collection<? extends PolicyMapMutator> collection) {
        PolicyMap policyMap = new PolicyMap();
        if (collection != null && !collection.isEmpty()) {
            for (PolicyMapMutator policyMapMutator : collection) {
                policyMapMutator.connect(policyMap);
            }
        }
        return policyMap;
    }

    public Policy getServiceEffectivePolicy(PolicyMapKey policyMapKey) throws PolicyException {
        return this.serviceMap.getEffectivePolicy(policyMapKey);
    }

    public Policy getEndpointEffectivePolicy(PolicyMapKey policyMapKey) throws PolicyException {
        return this.endpointMap.getEffectivePolicy(policyMapKey);
    }

    public Policy getOperationEffectivePolicy(PolicyMapKey policyMapKey) throws PolicyException {
        return this.operationMap.getEffectivePolicy(policyMapKey);
    }

    public Policy getInputMessageEffectivePolicy(PolicyMapKey policyMapKey) throws PolicyException {
        return this.inputMessageMap.getEffectivePolicy(policyMapKey);
    }

    public Policy getOutputMessageEffectivePolicy(PolicyMapKey policyMapKey) throws PolicyException {
        return this.outputMessageMap.getEffectivePolicy(policyMapKey);
    }

    public Policy getFaultMessageEffectivePolicy(PolicyMapKey policyMapKey) throws PolicyException {
        return this.faultMessageMap.getEffectivePolicy(policyMapKey);
    }

    public Collection<PolicyMapKey> getAllServiceScopeKeys() {
        return this.serviceMap.getAllKeys();
    }

    public Collection<PolicyMapKey> getAllEndpointScopeKeys() {
        return this.endpointMap.getAllKeys();
    }

    public Collection<PolicyMapKey> getAllOperationScopeKeys() {
        return this.operationMap.getAllKeys();
    }

    public Collection<PolicyMapKey> getAllInputMessageScopeKeys() {
        return this.inputMessageMap.getAllKeys();
    }

    public Collection<PolicyMapKey> getAllOutputMessageScopeKeys() {
        return this.outputMessageMap.getAllKeys();
    }

    public Collection<PolicyMapKey> getAllFaultMessageScopeKeys() {
        return this.faultMessageMap.getAllKeys();
    }

    void putSubject(ScopeType scopeType, PolicyMapKey policyMapKey, PolicySubject policySubject) {
        switch (scopeType) {
            case SERVICE: {
                this.serviceMap.putSubject(policyMapKey, policySubject);
                break;
            }
            case ENDPOINT: {
                this.endpointMap.putSubject(policyMapKey, policySubject);
                break;
            }
            case OPERATION: {
                this.operationMap.putSubject(policyMapKey, policySubject);
                break;
            }
            case INPUT_MESSAGE: {
                this.inputMessageMap.putSubject(policyMapKey, policySubject);
                break;
            }
            case OUTPUT_MESSAGE: {
                this.outputMessageMap.putSubject(policyMapKey, policySubject);
                break;
            }
            case FAULT_MESSAGE: {
                this.faultMessageMap.putSubject(policyMapKey, policySubject);
                break;
            }
            default: {
                throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0002_UNRECOGNIZED_SCOPE_TYPE((Object)scopeType)));
            }
        }
    }

    void setNewEffectivePolicyForScope(ScopeType scopeType, PolicyMapKey policyMapKey, Policy policy) throws IllegalArgumentException {
        if (scopeType == null || policyMapKey == null || policy == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0062_INPUT_PARAMS_MUST_NOT_BE_NULL()));
        }
        switch (scopeType) {
            case SERVICE: {
                this.serviceMap.setNewEffectivePolicy(policyMapKey, policy);
                break;
            }
            case ENDPOINT: {
                this.endpointMap.setNewEffectivePolicy(policyMapKey, policy);
                break;
            }
            case OPERATION: {
                this.operationMap.setNewEffectivePolicy(policyMapKey, policy);
                break;
            }
            case INPUT_MESSAGE: {
                this.inputMessageMap.setNewEffectivePolicy(policyMapKey, policy);
                break;
            }
            case OUTPUT_MESSAGE: {
                this.outputMessageMap.setNewEffectivePolicy(policyMapKey, policy);
                break;
            }
            case FAULT_MESSAGE: {
                this.faultMessageMap.setNewEffectivePolicy(policyMapKey, policy);
                break;
            }
            default: {
                throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0002_UNRECOGNIZED_SCOPE_TYPE((Object)scopeType)));
            }
        }
    }

    public Collection<PolicySubject> getPolicySubjects() {
        LinkedList<PolicySubject> linkedList = new LinkedList<PolicySubject>();
        this.addSubjects(linkedList, this.serviceMap);
        this.addSubjects(linkedList, this.endpointMap);
        this.addSubjects(linkedList, this.operationMap);
        this.addSubjects(linkedList, this.inputMessageMap);
        this.addSubjects(linkedList, this.outputMessageMap);
        this.addSubjects(linkedList, this.faultMessageMap);
        return linkedList;
    }

    public boolean isInputMessageSubject(PolicySubject policySubject) {
        for (PolicyScope policyScope : this.inputMessageMap.getStoredScopes()) {
            if (!policyScope.getPolicySubjects().contains(policySubject)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutputMessageSubject(PolicySubject policySubject) {
        for (PolicyScope policyScope : this.outputMessageMap.getStoredScopes()) {
            if (!policyScope.getPolicySubjects().contains(policySubject)) continue;
            return true;
        }
        return false;
    }

    public boolean isFaultMessageSubject(PolicySubject policySubject) {
        for (PolicyScope policyScope : this.faultMessageMap.getStoredScopes()) {
            if (!policyScope.getPolicySubjects().contains(policySubject)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.serviceMap.isEmpty() && this.endpointMap.isEmpty() && this.operationMap.isEmpty() && this.inputMessageMap.isEmpty() && this.outputMessageMap.isEmpty() && this.faultMessageMap.isEmpty();
    }

    private void addSubjects(Collection<PolicySubject> collection, ScopeMap scopeMap) {
        for (PolicyScope policyScope : scopeMap.getStoredScopes()) {
            Collection<PolicySubject> collection2 = policyScope.getPolicySubjects();
            collection.addAll(collection2);
        }
    }

    public static PolicyMapKey createWsdlServiceScopeKey(QName qName) throws IllegalArgumentException {
        if (qName == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0031_SERVICE_PARAM_MUST_NOT_BE_NULL()));
        }
        return new PolicyMapKey(qName, null, null, serviceKeyHandler);
    }

    public static PolicyMapKey createWsdlEndpointScopeKey(QName qName, QName qName2) throws IllegalArgumentException {
        if (qName == null || qName2 == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0033_SERVICE_AND_PORT_PARAM_MUST_NOT_BE_NULL(qName, qName2)));
        }
        return new PolicyMapKey(qName, qName2, null, endpointKeyHandler);
    }

    public static PolicyMapKey createWsdlOperationScopeKey(QName qName, QName qName2, QName qName3) throws IllegalArgumentException {
        return PolicyMap.createOperationOrInputOutputMessageKey(qName, qName2, qName3);
    }

    public static PolicyMapKey createWsdlMessageScopeKey(QName qName, QName qName2, QName qName3) throws IllegalArgumentException {
        return PolicyMap.createOperationOrInputOutputMessageKey(qName, qName2, qName3);
    }

    public static PolicyMapKey createWsdlFaultMessageScopeKey(QName qName, QName qName2, QName qName3, QName qName4) throws IllegalArgumentException {
        if (qName == null || qName2 == null || qName3 == null || qName4 == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0030_SERVICE_PORT_OPERATION_FAULT_MSG_PARAM_MUST_NOT_BE_NULL(qName, qName2, qName3, qName4)));
        }
        return new PolicyMapKey(qName, qName2, qName3, qName4, faultMessageHandler);
    }

    private static PolicyMapKey createOperationOrInputOutputMessageKey(QName qName, QName qName2, QName qName3) {
        if (qName == null || qName2 == null || qName3 == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0029_SERVICE_PORT_OPERATION_PARAM_MUST_NOT_BE_NULL(qName, qName2, qName3)));
        }
        return new PolicyMapKey(qName, qName2, qName3, operationAndInputOutputMessageKeyHandler);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != this.serviceMap) {
            stringBuffer.append("\nServiceMap=").append(this.serviceMap);
        }
        if (null != this.endpointMap) {
            stringBuffer.append("\nEndpointMap=").append(this.endpointMap);
        }
        if (null != this.operationMap) {
            stringBuffer.append("\nOperationMap=").append(this.operationMap);
        }
        if (null != this.inputMessageMap) {
            stringBuffer.append("\nInputMessageMap=").append(this.inputMessageMap);
        }
        if (null != this.outputMessageMap) {
            stringBuffer.append("\nOutputMessageMap=").append(this.outputMessageMap);
        }
        if (null != this.faultMessageMap) {
            stringBuffer.append("\nFaultMessageMap=").append(this.faultMessageMap);
        }
        return stringBuffer.toString();
    }

    @Override
    public Iterator<Policy> iterator() {
        return new Iterator<Policy>(){
            private final Iterator<Iterator<Policy>> mainIterator;
            private Iterator<Policy> currentScopeIterator;
            {
                ArrayList<Iterator<Policy>> arrayList = new ArrayList<Iterator<Policy>>(6);
                arrayList.add(PolicyMap.this.serviceMap.iterator());
                arrayList.add(PolicyMap.this.endpointMap.iterator());
                arrayList.add(PolicyMap.this.operationMap.iterator());
                arrayList.add(PolicyMap.this.inputMessageMap.iterator());
                arrayList.add(PolicyMap.this.outputMessageMap.iterator());
                arrayList.add(PolicyMap.this.faultMessageMap.iterator());
                this.mainIterator = arrayList.iterator();
                this.currentScopeIterator = this.mainIterator.next();
            }

            @Override
            public boolean hasNext() {
                while (!this.currentScopeIterator.hasNext()) {
                    if (this.mainIterator.hasNext()) {
                        this.currentScopeIterator = this.mainIterator.next();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public Policy next() {
                if (this.hasNext()) {
                    return this.currentScopeIterator.next();
                }
                throw LOGGER.logSevereException(new NoSuchElementException(LocalizationMessages.WSP_0054_NO_MORE_ELEMS_IN_POLICY_MAP()));
            }

            @Override
            public void remove() {
                throw LOGGER.logSevereException(new UnsupportedOperationException(LocalizationMessages.WSP_0034_REMOVE_OPERATION_NOT_SUPPORTED()));
            }
        };
    }

    private static final class ScopeMap
    implements Iterable<Policy> {
        private final Map<PolicyMapKey, PolicyScope> internalMap = new HashMap<PolicyMapKey, PolicyScope>();
        private final PolicyMapKeyHandler scopeKeyHandler;
        private final PolicyMerger merger;

        ScopeMap(PolicyMerger policyMerger, PolicyMapKeyHandler policyMapKeyHandler) {
            this.merger = policyMerger;
            this.scopeKeyHandler = policyMapKeyHandler;
        }

        Policy getEffectivePolicy(PolicyMapKey policyMapKey) throws PolicyException {
            PolicyScope policyScope = this.internalMap.get(this.createLocalCopy(policyMapKey));
            return policyScope == null ? null : policyScope.getEffectivePolicy(this.merger);
        }

        void putSubject(PolicyMapKey policyMapKey, PolicySubject policySubject) {
            PolicyMapKey policyMapKey2 = this.createLocalCopy(policyMapKey);
            PolicyScope policyScope = this.internalMap.get(policyMapKey2);
            if (policyScope == null) {
                LinkedList<PolicySubject> linkedList = new LinkedList<PolicySubject>();
                linkedList.add(policySubject);
                this.internalMap.put(policyMapKey2, new PolicyScope(linkedList));
            } else {
                policyScope.attach(policySubject);
            }
        }

        void setNewEffectivePolicy(PolicyMapKey policyMapKey, Policy policy) {
            PolicySubject policySubject = new PolicySubject((Object)policyMapKey, policy);
            PolicyMapKey policyMapKey2 = this.createLocalCopy(policyMapKey);
            PolicyScope policyScope = this.internalMap.get(policyMapKey2);
            if (policyScope == null) {
                LinkedList<PolicySubject> linkedList = new LinkedList<PolicySubject>();
                linkedList.add(policySubject);
                this.internalMap.put(policyMapKey2, new PolicyScope(linkedList));
            } else {
                policyScope.dettachAllSubjects();
                policyScope.attach(policySubject);
            }
        }

        Collection<PolicyScope> getStoredScopes() {
            return this.internalMap.values();
        }

        Set<PolicyMapKey> getAllKeys() {
            return this.internalMap.keySet();
        }

        private PolicyMapKey createLocalCopy(PolicyMapKey policyMapKey) {
            if (policyMapKey == null) {
                throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0045_POLICY_MAP_KEY_MUST_NOT_BE_NULL()));
            }
            PolicyMapKey policyMapKey2 = new PolicyMapKey(policyMapKey);
            policyMapKey2.setHandler(this.scopeKeyHandler);
            return policyMapKey2;
        }

        @Override
        public Iterator<Policy> iterator() {
            return new Iterator<Policy>(){
                private final Iterator<PolicyMapKey> keysIterator;
                {
                    this.keysIterator = ScopeMap.this.internalMap.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.keysIterator.hasNext();
                }

                @Override
                public Policy next() {
                    PolicyMapKey policyMapKey = this.keysIterator.next();
                    try {
                        return ScopeMap.this.getEffectivePolicy(policyMapKey);
                    }
                    catch (PolicyException policyException) {
                        throw LOGGER.logSevereException(new IllegalStateException(LocalizationMessages.WSP_0069_EXCEPTION_WHILE_RETRIEVING_EFFECTIVE_POLICY_FOR_KEY(policyMapKey), policyException));
                    }
                }

                @Override
                public void remove() {
                    throw LOGGER.logSevereException(new UnsupportedOperationException(LocalizationMessages.WSP_0034_REMOVE_OPERATION_NOT_SUPPORTED()));
                }
            };
        }

        public boolean isEmpty() {
            return this.internalMap.isEmpty();
        }

        public String toString() {
            return this.internalMap.toString();
        }
    }

    static enum ScopeType {
        SERVICE,
        ENDPOINT,
        OPERATION,
        INPUT_MESSAGE,
        OUTPUT_MESSAGE,
        FAULT_MESSAGE;

    }
}

