/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl;

import iaik.asn1.structures.AlgorithmID;
import iaik.tsp.MessageImprint;
import iaik.tsp.TimeStampReq;
import iaik.xml.crypto.xades.timestamp.TimeStampException;
import iaik.xml.crypto.xades.timestamp.TimeStampProcessor;
import iaik.xml.crypto.xades.timestamp.TimeStampToken;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.crypto.OctetStreamData;

public abstract class TSPTimeStampProcessor
implements TimeStampProcessor {
    public abstract TimeStampToken timeStamp(OctetStreamData var1) throws TimeStampException;

    protected TimeStampReq createTimeStampReq(MessageImprint messageImprint) {
        if (messageImprint == null) {
            throw new NullPointerException("Argument 'messageImprint' must not be null");
        }
        TimeStampReq timeStampReq = new TimeStampReq(messageImprint);
        timeStampReq.setCertReq(true);
        return timeStampReq;
    }

    protected MessageImprint calculateMessageImprint(OctetStreamData octetStreamData) throws TimeStampException {
        byte[] byArray;
        MessageDigest messageDigest;
        InputStream inputStream = octetStreamData.getOctetStream();
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new TimeStampException("Faild to calculate digest from given input, " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);
        try {
            byArray = new byte[4096];
            while (digestInputStream.read(byArray) != -1) {
            }
        }
        catch (IOException iOException) {
            throw new TimeStampException("Failed to calculate digest from given input", iOException);
        }
        byArray = messageDigest.digest();
        return new MessageImprint(AlgorithmID.sha1, byArray);
    }
}

