"""Response model definitions for client."""

from tekore._model import (
    AlbumType,
    Album,
    AlbumGroup,
    SimpleAlbum,
    SimpleAlbumPaging,
    FullAlbum,
    SavedAlbum,
    SavedAlbumPaging,
    Artist,
    SimpleArtist,
    FullArtist,
    FullArtistCursorPaging,
    FullArtistOffsetPaging,
    AudioAnalysis,
    TimeInterval,
    Section,
    Segment,
    AudioFeatures,
    Identifiable,
    Item,
    Category,
    CategoryPaging,
    ContextType,
    Context,
    CurrentlyPlayingType,
    CurrentlyPlayingContext,
    CurrentlyPlaying,
    RepeatState,
    Disallows,
    Actions,
    Device,
    DeviceType,
    ResumePoint,
    Episode,
    SimpleEpisode,
    SimpleEpisodePaging,
    FullEpisode,
    SavedEpisode,
    SavedEpisodePaging,
    PlayerErrorReason,
    LocalItem,
    LocalAlbum,
    LocalArtist,
    LocalTrack,
    ReleaseDatePrecision,
    Copyright,
    Followers,
    Image,
    Restrictions,
    Paging,
    OffsetPaging,
    Cursor,
    CursorPaging,
    PlayHistory,
    PlayHistoryCursor,
    PlayHistoryPaging,
    PlaylistTrack,
    PlaylistTrackPaging,
    Playlist,
    SimplePlaylist,
    FullPlaylist,
    SimplePlaylistPaging,
    FullPlaylistTrack,
    FullPlaylistEpisode,
    LocalPlaylistTrack,
    Recommendations,
    RecommendationSeed,
    RecommendationAttribute,
    Show,
    SimpleShow,
    SimpleShowPaging,
    SavedShow,
    SavedShowPaging,
    FullShow,
    TrackLink,
    Track,
    Tracks,
    SimpleTrack,
    SavedTrack,
    FullTrack,
    SimpleTrackPaging,
    SavedTrackPaging,
    FullTrackPaging,
    ExplicitContent,
    UnknownModelAttributeWarning,
    User,
    PrivateUser,
    PublicUser,
    Model,
    ModelList,
    Serialisable,
    StrEnum,
    Timestamp,
)

# Change the module of classes to hide module structure
# and fix Sphinx base class links
_classes = [
    AlbumType,
    Album,
    AlbumGroup,
    SimpleAlbum,
    SimpleAlbumPaging,
    FullAlbum,
    SavedAlbum,
    SavedAlbumPaging,
    Artist,
    SimpleArtist,
    FullArtist,
    FullArtistCursorPaging,
    FullArtistOffsetPaging,
    AudioAnalysis,
    TimeInterval,
    Section,
    Segment,
    AudioFeatures,
    Identifiable,
    Item,
    Category,
    CategoryPaging,
    ContextType,
    Context,
    CurrentlyPlayingType,
    CurrentlyPlayingContext,
    CurrentlyPlaying,
    RepeatState,
    Disallows,
    Actions,
    Device,
    DeviceType,
    ResumePoint,
    Episode,
    SimpleEpisode,
    SimpleEpisodePaging,
    FullEpisode,
    SavedEpisode,
    SavedEpisodePaging,
    PlayerErrorReason,
    LocalItem,
    LocalAlbum,
    LocalArtist,
    LocalTrack,
    ReleaseDatePrecision,
    Copyright,
    Followers,
    Image,
    Restrictions,
    Paging,
    OffsetPaging,
    Cursor,
    CursorPaging,
    PlayHistory,
    PlayHistoryCursor,
    PlayHistoryPaging,
    PlaylistTrack,
    PlaylistTrackPaging,
    Playlist,
    SimplePlaylist,
    FullPlaylist,
    SimplePlaylistPaging,
    FullPlaylistTrack,
    FullPlaylistEpisode,
    LocalPlaylistTrack,
    Recommendations,
    RecommendationSeed,
    RecommendationAttribute,
    Show,
    SimpleShow,
    SimpleShowPaging,
    SavedShow,
    SavedShowPaging,
    FullShow,
    TrackLink,
    Track,
    Tracks,
    SimpleTrack,
    SavedTrack,
    FullTrack,
    SimpleTrackPaging,
    SavedTrackPaging,
    FullTrackPaging,
    ExplicitContent,
    UnknownModelAttributeWarning,
    User,
    PrivateUser,
    PublicUser,
    Model,
    ModelList,
    Serialisable,
    StrEnum,
    Timestamp,
]

for _cls in _classes:
    _cls.__module__ = 'tekore.model'
