/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.window;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.plugins.graph.GraphMainPanelTab;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPanelController;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.LazyLoadListener;
import net.sourceforge.squirrel_sql.plugins.graph.window.GraphWindowController;
import net.sourceforge.squirrel_sql.plugins.graph.window.GraphWindowControllerListener;

public class TabToWindowHandler {
    private GraphMainPanelTab _graphMainPanelTab;
    private ISession _session;
    private GraphPlugin _plugin;
    private boolean _link;
    private GraphWindowController _graphWindowController;
    private LazyLoadListener _lazyLoadListener;

    public TabToWindowHandler(GraphPanelController panelController, ISession session, GraphPlugin plugin, boolean isLink) {
        this._session = session;
        this._plugin = plugin;
        this._link = isLink;
        this._graphMainPanelTab = new GraphMainPanelTab(panelController, plugin, this._link);
        this._graphMainPanelTab.getToWindowButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabToWindowHandler.this.toWindow();
            }
        });
    }

    private void toWindow() {
        this._lazyLoadListener.lazyLoadTables();
        Dimension size = this._graphMainPanelTab.getComponent().getSize();
        Point screenLoc = GUIUtils.getScreenLocationFor((Component)this._graphMainPanelTab.getComponent());
        Rectangle tabBoundsOnScreen = new Rectangle();
        tabBoundsOnScreen.x = screenLoc.x;
        tabBoundsOnScreen.y = screenLoc.y;
        tabBoundsOnScreen.width = size.width;
        tabBoundsOnScreen.height = size.height;
        this.toWindowAtBounds(tabBoundsOnScreen);
    }

    private void toWindowAtBounds(Rectangle tabBoundsOnScreen) {
        int tabIdx = this._session.getSessionPanel().removeMainTab((IMainPanelTab)this._graphMainPanelTab);
        GraphWindowControllerListener listener = new GraphWindowControllerListener(){

            @Override
            public void closing(int tabIdx) {
                TabToWindowHandler.this.onWindowClosing(tabIdx);
            }
        };
        this._graphWindowController = new GraphWindowController(this._session, this._plugin, this._graphMainPanelTab, tabIdx, tabBoundsOnScreen, listener, this._link);
    }

    private void onWindowClosing(int tabIdx) {
        this._graphWindowController = null;
        if (tabIdx < this._session.getSessionPanel().getTabCount()) {
            this._session.getSessionPanel().insertMainTab((IMainPanelTab)this._graphMainPanelTab, tabIdx);
        } else {
            tabIdx = this._session.getSessionPanel().addMainTab((IMainPanelTab)this._graphMainPanelTab);
            this._session.getSessionPanel().selectMainTab(tabIdx);
        }
    }

    public void showGraph(LazyLoadListener lazyLoadListener, boolean selectTab) {
        this._lazyLoadListener = lazyLoadListener;
        this._graphMainPanelTab.setLazyLoadListener(this._lazyLoadListener);
        int tabIdx = this._session.getSessionPanel().addMainTab((IMainPanelTab)this._graphMainPanelTab);
        if (selectTab) {
            this._session.getSessionPanel().selectMainTab(tabIdx);
        }
    }

    public void removeGraph() {
        if (null == this._graphWindowController) {
            this._session.getSessionPanel().removeMainTab((IMainPanelTab)this._graphMainPanelTab);
        } else {
            this._graphWindowController.close();
            this._graphWindowController = null;
        }
    }

    public void renameGraph(String newName) {
        this._graphMainPanelTab.setTitle(newName);
        if (null == this._graphWindowController) {
            int index = this._session.getSessionPanel().removeMainTab((IMainPanelTab)this._graphMainPanelTab);
            this._session.getSessionPanel().insertMainTab((IMainPanelTab)this._graphMainPanelTab, index);
        } else {
            this._graphWindowController.rename(newName);
        }
    }

    public String getTitle() {
        return this._graphMainPanelTab.getTitle();
    }

    public void setTitle(String title) {
        this._graphMainPanelTab.setTitle(title);
    }

    public void showInWindowBesidesObjectTree() {
        this._session.selectMainTab(0);
        Component detailTabComp = this._session.getObjectTreeAPIOfActiveSessionWindow().getDetailTabComp();
        Point locOnScreen = GUIUtils.getScreenLocationFor((Component)detailTabComp);
        Rectangle bounds = new Rectangle(locOnScreen.x, locOnScreen.y, detailTabComp.getWidth(), detailTabComp.getHeight());
        this.toWindowAtBounds(bounds);
    }

    public void toggleWindowTab() {
        if (null == this._graphWindowController) {
            this.toWindow();
        } else {
            this._graphWindowController.returnToTab();
        }
    }

    public void changedFromLinkToLocalCopy() {
        this._link = false;
        if (null == this._graphWindowController) {
            this._graphMainPanelTab.changedFromLinkToLocalCopy();
        } else {
            this._graphWindowController.changedFromLinkToLocalCopy();
        }
    }

    public Component getComponent() {
        if (null == this._graphWindowController) {
            return this._graphMainPanelTab.getComponent();
        }
        return this._graphWindowController.getComponent();
    }

    public boolean isMyGraphMainPanelTab(GraphMainPanelTab graphMainPanelTab) {
        return this._graphMainPanelTab == graphMainPanelTab;
    }
}

