/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.ExtendedColumnInfo;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISessionListener;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.EditExtrasAccessor;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModelChangeType;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.QueryFilterDlg;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.QueryFilterListener;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.QueryFilterOperators;

public class QueryFilterController {
    private QueryFilterDlg _queryFilterDlg;
    private String _tableName;
    private ColumnInfo _columnInfo;
    private ISession _session;
    private QueryFilterListener _queryFilterListener;
    private static final String PREF_KEY_QUERY_ALWAYS_APPEND_QUOTES = "Squirrel.queryFilterDlgCtrl.AlwaysAppendQuotes";
    private SessionAdapter _sessionAdapter;

    public QueryFilterController(Window parent, String tableName, ColumnInfo columnInfo, GraphPlugin graphPlugin, ISession session, QueryFilterListener queryFilterListener) {
        this._tableName = tableName;
        this._columnInfo = columnInfo;
        this._session = session;
        this._sessionAdapter = new SessionAdapter(){

            public void sessionClosing(SessionEvent evt) {
                QueryFilterController.this.onSessionClosing(evt);
            }
        };
        this._session.getApplication().getSessionManager().addSessionListener((ISessionListener)this._sessionAdapter);
        this._queryFilterListener = queryFilterListener;
        this._queryFilterDlg = new QueryFilterDlg(parent, new GraphPluginResources((IPlugin)graphPlugin), tableName + "." + this._columnInfo.toString());
        boolean applyQuotes = Props.getBoolean((String)PREF_KEY_QUERY_ALWAYS_APPEND_QUOTES, (boolean)false);
        this._queryFilterDlg._chkApplyQuotes.setSelected(applyQuotes);
        this._queryFilterDlg._btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryFilterController.this.onOK();
            }
        });
        this._queryFilterDlg._btnClearFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryFilterController.this.onClearFilter();
            }
        });
        this._queryFilterDlg._btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryFilterController.this.close();
            }
        });
        this._queryFilterDlg._cboOperator.setModel(new DefaultComboBoxModel<QueryFilterOperators>(QueryFilterOperators.values()));
        this._queryFilterDlg._cboOperator.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QueryFilterController.this.onOperatorChanged(e);
            }
        });
        this._queryFilterDlg._btnEscapeDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryFilterController.this.onEscapeDate();
            }
        });
        if (null == columnInfo.getQueryData().getOperator()) {
            this._queryFilterDlg._cboOperator.setSelectedItem((Object)QueryFilterOperators.EQUAL);
        } else {
            this._queryFilterDlg._cboOperator.setSelectedItem((Object)columnInfo.getQueryData().getOperator());
        }
        this._queryFilterDlg._txtFilter.setText(this._columnInfo.getQueryData().getFilterValue());
        GUIUtils.centerWithinParent((Window)this._queryFilterDlg);
        this._queryFilterDlg.setVisible(true);
        this._queryFilterDlg._txtFilter.requestFocus();
    }

    private void onEscapeDate() {
        String dateEscape = EditExtrasAccessor.getDateEscape(this._queryFilterDlg);
        if (null != dateEscape && 0 < dateEscape.trim().length()) {
            this._queryFilterDlg._txtFilter.setText(dateEscape);
        }
    }

    private void onSessionClosing(SessionEvent evt) {
        if (evt.getSession().getIdentifier().equals((Object)this._session.getIdentifier())) {
            this.close();
        }
        this._session.getApplication().getSessionManager().removeSessionListener((ISessionListener)this._sessionAdapter);
    }

    private void onOperatorChanged(ItemEvent e) {
        if (2 == e.getStateChange()) {
            return;
        }
        QueryFilterOperators selectedOp = (QueryFilterOperators)((Object)this._queryFilterDlg._cboOperator.getSelectedItem());
        if (QueryFilterOperators.isNoArgOperator(selectedOp)) {
            this._queryFilterDlg._txtFilter.setEnabled(false);
            this._queryFilterDlg._btnEscapeDate.setEnabled(false);
        } else {
            this._queryFilterDlg._txtFilter.setEnabled(true);
            this._queryFilterDlg._btnEscapeDate.setEnabled(true);
        }
    }

    private void onClearFilter() {
        this._columnInfo.getQueryData().clearFilter();
        this._queryFilterListener.filterChanged();
        this._queryFilterDlg.saveCurrentSize();
        this.close();
        this._columnInfo.getColumnInfoModelEventDispatcher().fireChanged(TableFramesModelChangeType.COLUMN_WHERE);
    }

    private void onOK() {
        QueryFilterOperators operator = (QueryFilterOperators)((Object)this._queryFilterDlg._cboOperator.getSelectedItem());
        this._columnInfo.getQueryData().setOperator(operator);
        this._columnInfo.getQueryData().setFilterValue(null);
        String text = this._queryFilterDlg._txtFilter.getText();
        if (null != text && 0 < text.length()) {
            ExtendedColumnInfo ec = this.getExtendedColumnInfo();
            if (this._queryFilterDlg._chkApplyQuotes.isSelected() && null != ec && ec.isCharacterType() && operator.isSingleValued()) {
                this._columnInfo.getQueryData().setFilterValue(this.getQuotedText(text));
            } else {
                this._columnInfo.getQueryData().setFilterValue(text);
            }
        }
        this._queryFilterListener.filterChanged();
        this._queryFilterDlg.saveCurrentSize();
        Props.putBoolean((String)PREF_KEY_QUERY_ALWAYS_APPEND_QUOTES, (boolean)this._queryFilterDlg._chkApplyQuotes.isSelected());
        this.close();
        this._columnInfo.getColumnInfoModelEventDispatcher().fireChanged(TableFramesModelChangeType.COLUMN_WHERE);
    }

    private String getQuotedText(String text) {
        if (!text.trim().startsWith("'") || !text.trim().endsWith("'")) {
            return "'" + text.trim().replaceAll("'", "''") + "'";
        }
        return text;
    }

    private ExtendedColumnInfo getExtendedColumnInfo() {
        ExtendedColumnInfo[] extendedColumnInfos;
        for (ExtendedColumnInfo extendedColumnInfo : extendedColumnInfos = this._session.getSchemaInfo().getExtendedColumnInfos(this._tableName)) {
            if (!extendedColumnInfo.getColumnName().equalsIgnoreCase(this._columnInfo.getName())) continue;
            return extendedColumnInfo;
        }
        return null;
    }

    private void close() {
        this._queryFilterDlg.setVisible(false);
        this._queryFilterDlg.dispose();
        this._session.getApplication().getSessionManager().addSessionListener((ISessionListener)this._sessionAdapter);
    }
}

