/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.commands.handler;

import java.sql.SQLWarning;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetWrapper;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.commands.handler.ProgressSQLExecuterHandler;
import net.sourceforge.squirrel_sql.plugins.postgres.gui.MessageDialog;

public abstract class MessageSQLExecuterHandler
extends ProgressSQLExecuterHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MessageSQLExecuterHandler.class);
    protected MessageDialog _mdialog;
    protected long _startTime;
    protected boolean _exceptionOccured = false;

    public MessageSQLExecuterHandler(ISession session, MessageDialog mdialog, String progressDialogTitle, String commandPrefix) {
        super(session, mdialog, progressDialogTitle, commandPrefix);
        this._mdialog = mdialog;
    }

    @Override
    public void sqlToBeExecuted(String sql) {
        super.sqlToBeExecuted(sql);
        this._mdialog.writeLine("========= " + this._commandPrefix + " " + this.getSuffix(sql) + " =========");
    }

    @Override
    protected abstract String getSuffix(String var1);

    @Override
    public void sqlExecutionComplete(SQLExecutionInfo info, int processedStatementCount, int statementCount) {
        super.sqlExecutionComplete(info, processedStatementCount, statementCount);
        this._mdialog.writeEmptyLine();
    }

    @Override
    public void sqlExecutionWarning(SQLWarning warn) {
        this._mdialog.writeLine(warn.toString());
    }

    @Override
    public void sqlStatementCount(int statementCount) {
        super.sqlStatementCount(statementCount);
        this._startTime = System.currentTimeMillis();
    }

    @Override
    public void sqlCloseExecutionHandler(ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
        super.sqlCloseExecutionHandler(sqlExecErrorMsgs, lastExecutedStatement);
        if (!this._exceptionOccured) {
            float executionTime = (float)(System.currentTimeMillis() - this._startTime) / 1000.0f;
            this._mdialog.writeEmptyLine();
            this._mdialog.writeLine(s_stringMgr.getString("MessageSQLExecuterHandler.done", new Object[]{this._commandPrefix, Float.valueOf(executionTime)}));
        }
        this._mdialog.enableCloseButton();
    }

    @Override
    public void sqlExecutionCancelled() {
        super.sqlExecutionCancelled();
    }

    @Override
    public void sqlDataUpdated(int updateCount) {
        super.sqlDataUpdated(updateCount);
    }

    @Override
    public void sqlResultSetAvailable(ResultSetWrapper rst, SQLExecutionInfo info, IDataSetUpdateableTableModel model) {
        super.sqlResultSetAvailable(rst, info, model);
    }

    @Override
    public String sqlExecutionException(Throwable th, String postErrorString) {
        String ret = super.sqlExecutionException(th, postErrorString);
        this._mdialog.writeEmptyLine();
        this._mdialog.writeLine(s_stringMgr.getString("MessageSQLExecuterHandler.aborted", new Object[]{this._commandPrefix}));
        this._exceptionOccured = true;
        return ret;
    }
}

