/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextPrefs;
import org.fife.rtext.StoreKeeper;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.rtextfilechooser.RTextFileChooser;

class OpenInNewWindowAction
extends AppAction<RText> {
    private RText newWindow;

    OpenInNewWindowAction(RText owner, ResourceBundle msg, Icon icon) {
        super((GUIApplication)owner, msg, "OpenInNewWindowAction");
        this.setIcon(icon);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        this.newWindow = new RText(null, new RTextPrefs().populate((RText)this.getApplication()));
        StoreKeeper.addRTextInstance(this.newWindow);
        SwingUtilities.invokeLater(new OpenFileChooserRunnable());
    }

    private class OpenFileChooserRunnable
    implements Runnable {
        private OpenFileChooserRunnable() {
        }

        @Override
        public void run() {
            RTextFileChooser chooser = OpenInNewWindowAction.this.newWindow.getFileChooser();
            chooser.setMultiSelectionEnabled(true);
            int returnVal = chooser.showOpenDialog((Window)((Object)OpenInNewWindowAction.this.newWindow));
            if (returnVal == 0) {
                File[] selectedFiles;
                AbstractMainView newMainView = OpenInNewWindowAction.this.newWindow.getMainView();
                RTextEditorPane newCurrentTextArea = newMainView.getCurrentTextArea();
                String encoding = chooser.getEncoding();
                if (newCurrentTextArea != null) {
                    newCurrentTextArea.removeCaretListener(OpenInNewWindowAction.this.newWindow);
                }
                RText owner = (RText)OpenInNewWindowAction.this.getApplication();
                if (newMainView.getNumDocuments() == 1 && newCurrentTextArea.getFileName().equals(owner.getNewFileName()) && newCurrentTextArea.getDocument().getLength() == 0) {
                    newMainView.closeCurrentDocument();
                }
                for (File selectedFile : selectedFiles = chooser.getSelectedFiles()) {
                    String file = selectedFile.getAbsolutePath();
                    newMainView.openFile(file, encoding);
                }
            }
        }
    }
}

