/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.PropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstitute;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.HibernatePropertyReader;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.IType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.PersistentCollectionType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.SingleResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ViewObjectsUtil;

public class SingleType
implements IType {
    private MappedClassInfo _mappedClassInfo;
    private ArrayList<MappedClassInfo> _allMappedClassInfos;
    private ArrayList<SingleResult> _results = new ArrayList();
    private ArrayList<IType> _kidTypes;
    private String _toString;

    public SingleType(MappedClassInfo mappedClassInfo, ArrayList<MappedClassInfo> allMappedClassInfos, List<ObjectSubstitute> objects) {
        this(null, mappedClassInfo, allMappedClassInfos, objects);
    }

    public SingleType(String propertyName, MappedClassInfo mappedClassInfo, ArrayList<MappedClassInfo> allMappedClassInfos, List<ObjectSubstitute> objects) {
        this._mappedClassInfo = mappedClassInfo;
        this._allMappedClassInfos = allMappedClassInfos;
        for (ObjectSubstitute object : objects) {
            this._results.add(new SingleResult(propertyName, object, mappedClassInfo));
        }
        this._toString = null == propertyName ? this._mappedClassInfo.getClassName() : propertyName + ": " + this._mappedClassInfo.getClassName();
    }

    @Override
    public ArrayList<? extends IType> getKidTypes() {
        this.initKidTypes();
        return this._kidTypes;
    }

    private void initKidTypes() {
        if (null != this._kidTypes) {
            return;
        }
        PropertyInfo[] propertyInfos = this._mappedClassInfo.getAttributes();
        this._kidTypes = new ArrayList();
        for (PropertyInfo propertyInfo : propertyInfos) {
            String propertyName = propertyInfo.getHibernatePropertyInfo().getPropertyName();
            MappedClassInfo mci = null;
            ArrayList<ObjectSubstitute> objects = new ArrayList<ObjectSubstitute>();
            boolean persistentCollection = false;
            boolean persistentCollectionInitialized = false;
            for (SingleResult singleResult : this._results) {
                HibernatePropertyReader hpr = new HibernatePropertyReader(propertyName, singleResult.getObject());
                if (!hpr.isNull() && hpr.isPersistenCollection()) {
                    persistentCollection = true;
                    persistentCollectionInitialized = hpr.wasInitialized();
                    if (null == mci) {
                        mci = propertyInfo.getMappedClassInfo();
                    }
                    if (!persistentCollectionInitialized) continue;
                    objects.addAll(hpr.getPersistentCollection());
                    continue;
                }
                if (null == ViewObjectsUtil.findMappedClassInfo(hpr.getTypeName(), this._allMappedClassInfos, true)) continue;
                if (null == mci) {
                    mci = ViewObjectsUtil.findMappedClassInfo(hpr.getTypeName(), this._allMappedClassInfos, false);
                }
                if (null == mci || mci.isPlainValueArray()) continue;
                objects.add((ObjectSubstitute)hpr.getValue());
            }
            if (null == mci) continue;
            SingleType singleType = new SingleType(propertyName, mci, this._allMappedClassInfos, objects);
            if (persistentCollection) {
                this._kidTypes.add(new PersistentCollectionType(propertyName, singleType, persistentCollectionInitialized));
                continue;
            }
            this._kidTypes.add(singleType);
        }
    }

    public ArrayList<SingleResult> getResults() {
        return this._results;
    }

    public MappedClassInfo getMappedClassInfo() {
        return this._mappedClassInfo;
    }

    public String toString() {
        return this._toString;
    }

    public ArrayList<MappedClassInfo> getAllMappedClassInfos() {
        return this._allMappedClassInfos;
    }
}

