/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.codecompletion;

import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.preferences.INewSessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.client.session.properties.ISessionPropertiesPanel;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionInfoCollection;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CompleteCodeAction;
import net.sourceforge.squirrel_sql.plugins.codecompletion.Resources;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.CodeCompletionPreferences;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.CodeCompletionPreferencesController;

public class CodeCompletionPlugin
extends DefaultSessionPlugin {
    private static final ILogger s_log = LoggerController.createLogger(CodeCompletionPlugin.class);
    private Resources _resources;
    private static final String PREFS_FILE_NAME = "codecompletionprefs.xml";
    private CodeCompletionPreferences _newSessionPrefs;
    public static final String PLUGIN_OBJECT_PREFS_KEY = "codecompletionprefs";

    public String getInternalName() {
        return "codecompletion";
    }

    public String getDescriptiveName() {
        return "SQL Entry Code Completion";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getContributors() {
        return "Christian Sell";
    }

    public String getAuthor() {
        return "Gerd Wagner";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public void initialize() throws PluginException {
        this._resources = new Resources((IPlugin)this);
        this.loadPrefs();
    }

    public void unload() {
        this.savePrefs();
    }

    private void savePrefs() {
        try {
            FileWrapper prefsFile = this.fileWrapperFactory.create(this.getPluginUserSettingsFolder().getAbsolutePath(), PREFS_FILE_NAME);
            XMLBeanWriter wtr = new XMLBeanWriter((Object)this._newSessionPrefs);
            wtr.save(prefsFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadPrefs() {
        try {
            this._newSessionPrefs = new CodeCompletionPreferences();
            FileWrapper prefsFile = this.fileWrapperFactory.create(this.getPluginUserSettingsFolder(), PREFS_FILE_NAME);
            if (prefsFile.exists()) {
                XMLBeanReader reader = new XMLBeanReader();
                reader.load(prefsFile, ((Object)((Object)this)).getClass().getClassLoader());
                Iterator it = reader.iterator();
                if (it.hasNext()) {
                    this._newSessionPrefs = (CodeCompletionPreferences)it.next();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public INewSessionPropertiesPanel[] getNewSessionPropertiesPanels() {
        return new INewSessionPropertiesPanel[]{new CodeCompletionPreferencesController(this._newSessionPrefs)};
    }

    public ISessionPropertiesPanel[] getSessionPropertiesPanels(ISession session) {
        CodeCompletionPreferences sessionPrefs = (CodeCompletionPreferences)session.getPluginObject((IPlugin)this, PLUGIN_OBJECT_PREFS_KEY);
        return new ISessionPropertiesPanel[]{new CodeCompletionPreferencesController(sessionPrefs)};
    }

    public void sessionCreated(ISession session) {
        CodeCompletionPreferences prefs = (CodeCompletionPreferences)Utilities.cloneObject((Object)this._newSessionPrefs, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        session.putPluginObject((IPlugin)this, PLUGIN_OBJECT_PREFS_KEY, (Object)prefs);
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        ISQLPanelAPI sqlPaneAPI = session.getSessionPanel().getMainSQLPaneAPI();
        this.initCodeCompletionSqlEditor(sqlPaneAPI, session);
        this.initCodeCompletionObjectTreeFind(session, session.getSessionPanel().getObjectTreePanel());
        PluginSessionCallback ret = new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
                CodeCompletionPlugin.this.initCodeCompletionSqlEditor(sqlInternalFrame.getMainSQLPanelAPI(), sess);
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
                CodeCompletionPlugin.this.initCodeCompletionObjectTreeFind(sess, objectTreeInternalFrame.getObjectTreePanel());
            }

            public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
                CodeCompletionPlugin.this.initCodeCompletionSqlEditor(additionalSQLTab.getSQLPanelAPI(), additionalSQLTab.getSession());
            }
        };
        return ret;
    }

    private void initCodeCompletionSqlEditor(ISQLPanelAPI sqlPaneAPI, ISession session) {
        GUIUtils.processOnSwingEventThread(() -> this._initCodeCompletionSqlEditor(session, sqlPaneAPI));
    }

    private void initCodeCompletionObjectTreeFind(ISession session, ObjectTreePanel objectTreePanel) {
        GUIUtils.processOnSwingEventThread(() -> this._initCodeCompletionObjectTreeFind(objectTreePanel, session));
    }

    private void _initCodeCompletionSqlEditor(ISession session, ISQLPanelAPI sqlPaneAPI) {
        CodeCompletionInfoCollection c = new CodeCompletionInfoCollection(session, this, true);
        CompleteCodeAction cca = new CompleteCodeAction(session.getApplication(), this, sqlPaneAPI.getSQLEntryPanel(), session, c, null);
        JMenuItem item = sqlPaneAPI.addToSQLEntryAreaMenu((Action)((Object)cca));
        this._resources.configureMenuItem((Action)((Object)cca), item);
        JTextArea comp = sqlPaneAPI.getSQLEntryPanel().getTextComponent();
        comp.registerKeyboardAction((ActionListener)((Object)cca), this._resources.getKeyStroke((Action)((Object)cca)), 1);
        sqlPaneAPI.addToToolsPopUp("completecode", (Action)((Object)cca));
    }

    private void _initCodeCompletionObjectTreeFind(ObjectTreePanel objectTreePanel, ISession session) {
        ISQLEntryPanel findEntryPanel = objectTreePanel.getFindController().getFindEntryPanel();
        CodeCompletionInfoCollection c = new CodeCompletionInfoCollection(session, this, false);
        CompleteCodeAction cca = new CompleteCodeAction(session.getApplication(), this, findEntryPanel, session, c, (JComponent)objectTreePanel);
        JTextArea comp = findEntryPanel.getTextComponent();
        comp.registerKeyboardAction((ActionListener)((Object)cca), this._resources.getKeyStroke((Action)((Object)cca)), 1);
    }

    public PluginResources getResources() {
        return this._resources;
    }
}

