/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.importer.excel;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.FailedToInterpretHandler;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.IFileImporter;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.excel.ExcelSettingsBean;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.excel.ExcelSettingsPanel;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelFileImporter
implements IFileImporter {
    private File importFile;
    private int pointer = -1;
    private int size = 0;
    private Workbook workbook = null;
    private Sheet sheet = null;
    private ExcelSettingsBean settings;
    private boolean _trimValues;
    private FailedToInterpretHandler _failedToInterpretHandler = new FailedToInterpretHandler();

    public ExcelFileImporter(File importFile) {
        this.importFile = importFile;
        this.settings = new ExcelSettingsBean();
    }

    @Override
    public boolean open() throws IOException {
        try {
            this.workbook = WorkbookFactory.create((File)this.importFile);
        }
        catch (InvalidFormatException fe) {
            throw new IOException(fe.toString());
        }
        this.reset();
        return true;
    }

    @Override
    public boolean close() throws IOException {
        return true;
    }

    @Override
    public String[][] getPreview(int noOfLines) throws IOException {
        String[][] data = null;
        Workbook wb = null;
        Sheet sht = null;
        try {
            wb = WorkbookFactory.create((File)this.importFile);
            sht = this.getSheet(wb);
        }
        catch (InvalidFormatException fe) {
            throw new IOException(fe.toString());
        }
        if (0 == sht.getPhysicalNumberOfRows()) {
            throw new IllegalStateException("The Excel sheet has no rows.");
        }
        int maxLines = noOfLines < sht.getPhysicalNumberOfRows() ? noOfLines : sht.getPhysicalNumberOfRows();
        Row row = sht.getRow(0);
        data = new String[maxLines][row.getPhysicalNumberOfCells()];
        for (int y = 0; y < maxLines; ++y) {
            row = sht.getRow(y);
            for (int x = 0; x < row.getPhysicalNumberOfCells(); ++x) {
                data[y][x] = null == row.getCell(x) ? null : row.getCell(x).toString();
            }
        }
        return data;
    }

    @Override
    public boolean reset() {
        this.sheet = this.getSheet(this.workbook);
        this.size = this.sheet.getPhysicalNumberOfRows();
        this.pointer = -1;
        return true;
    }

    @Override
    public boolean next() {
        if (this.pointer >= this.size - 1) {
            return false;
        }
        ++this.pointer;
        return true;
    }

    private void checkPointer() throws IOException {
        if (this.pointer < 0) {
            throw new IOException("Use next() to get to the first record.");
        }
    }

    @Override
    public String getString(int column) throws IOException {
        this.checkPointer();
        if (null == this.sheet.getRow(this.pointer).getCell(column)) {
            return null;
        }
        if (this._trimValues) {
            String ret = this.sheet.getRow(this.pointer).getCell(column).toString();
            if (null == ret) {
                return ret;
            }
            return ret.trim();
        }
        return this.sheet.getRow(this.pointer).getCell(column).toString();
    }

    @Override
    public Integer getInt(int column) throws IOException {
        Double ret = this.getDouble(column);
        if (null == ret) {
            return null;
        }
        return ret.intValue();
    }

    @Override
    public Double getDouble(int column) throws IOException {
        this.checkPointer();
        Cell cell = this.sheet.getRow(this.pointer).getCell(column);
        if (null == cell) {
            return null;
        }
        if (cell.getCellType() == 1) {
            String buf = this.getString(column);
            try {
                return new Double(buf);
            }
            catch (NumberFormatException e) {
                return this._failedToInterpretHandler.failedToInterpretNumeric(column, buf);
            }
        }
        return cell.getNumericCellValue();
    }

    @Override
    public Date getDate(int column) throws IOException {
        this.checkPointer();
        Cell cell = this.sheet.getRow(this.pointer).getCell(column);
        if (null == cell) {
            return null;
        }
        if (cell.getCellType() == 1) {
            String buf = this.getString(column);
            try {
                return new SimpleDateFormat().parse(buf);
            }
            catch (ParseException e) {
                return this._failedToInterpretHandler.failedToInterpretDate(column, buf);
            }
        }
        return DateUtil.getJavaDate((double)cell.getNumericCellValue());
    }

    @Override
    public Long getLong(int column) throws IOException {
        Double ret = this.getDouble(column);
        if (null == ret) {
            return null;
        }
        return ret.longValue();
    }

    @Override
    public JComponent getConfigurationPanel() {
        return new ExcelSettingsPanel(this.settings, this.importFile);
    }

    @Override
    public void setTrimValues(boolean trimValues) {
        this._trimValues = trimValues;
    }

    @Override
    public String getImportFileTypeDescription() {
        return "MS EXCEL";
    }

    private Sheet getSheet(Workbook wb) {
        Sheet s = null;
        if (this.settings.getSheetName() != null) {
            s = wb.getSheet(this.settings.getSheetName());
        }
        if (s == null) {
            s = wb.getSheetAt(0);
        }
        return s;
    }
}

