/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlparam;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SelectWidgetCommand;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.SQLExecutionAdapter;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.QueryHolder;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlparam.SQLParamPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlparam.gui.AskParamValueDialog;

public class SQLParamExecutionListener
extends SQLExecutionAdapter {
    private static final ILogger log = LoggerController.createLogger(SQLParamPlugin.class);
    private ISession session = null;
    private SQLParamPlugin plugin = null;
    private AskParamValueDialog dialog = null;

    public SQLParamExecutionListener(SQLParamPlugin plugin, ISession session) {
        this.session = session;
        this.plugin = plugin;
    }

    public void statementExecuted(QueryHolder sql) {
    }

    public String statementExecuting(String sql) {
        sql = SQLParamExecutionListener.removeComments(sql);
        sql = sql.replaceAll("\\/\\*(.|\\s)*?\\*\\/", "");
        StringBuffer buffer = new StringBuffer(sql);
        Map<String, String> cache = this.plugin.getCache();
        HashMap<String, String> currentCache = new HashMap<String, String>();
        Pattern p = Pattern.compile("[\\ \\(]:[a-zA-Z]\\w+");
        Matcher m = p.matcher(buffer);
        boolean parametersWhereReplaced = false;
        while (m.find()) {
            if (this.isQuoted(buffer, m.start())) continue;
            final String var = m.group();
            String value = null;
            if (currentCache.containsKey(var)) {
                value = (String)currentCache.get(var);
            } else {
                final String oldValue = cache.get(var);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.createParameterDialog(var, oldValue);
                    while (!this.dialog.isDone()) {
                        try {
                            AWTEvent event = Toolkit.getDefaultToolkit().getSystemEventQueue().getNextEvent();
                            Object source = event.getSource();
                            if (event instanceof ActiveEvent) {
                                ((ActiveEvent)((Object)event)).dispatch();
                                continue;
                            }
                            if (source instanceof Component) {
                                ((Component)source).dispatchEvent(event);
                                continue;
                            }
                            if (source instanceof MenuComponent) {
                                ((MenuComponent)source).dispatchEvent(event);
                                continue;
                            }
                            System.err.println("Unable to dispatch: " + event);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                SQLParamExecutionListener.this.createParameterDialog(var, oldValue);
                            }
                        });
                        while (!this.dialog.isDone()) {
                            ((Object)((Object)this)).wait();
                        }
                    }
                    catch (InvocationTargetException ite) {
                        ite.printStackTrace();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                if (this.dialog.isCancelled()) {
                    this.dialog = null;
                    return null;
                }
                value = this.sanitizeValue(this.dialog.getValue(), this.dialog.isQuotingNeeded());
                cache.put(var, this.dialog.getValue());
                currentCache.put(var, value);
                this.dialog = null;
            }
            buffer.replace(m.start(), m.end(), value);
            parametersWhereReplaced = true;
            m.reset();
        }
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                new SelectWidgetCommand((IWidget)SQLParamExecutionListener.this.session.getActiveSessionWindow()).execute();
            }
        });
        if (parametersWhereReplaced) {
            return buffer.toString();
        }
        return sql;
    }

    private static String removeComments(String sql) {
        ArrayList<Integer> literalsStartPositions = new ArrayList<Integer>();
        ArrayList<Integer> literalsEndPositions = new ArrayList<Integer>();
        Matcher lm = Pattern.compile("('(('')|[^'])*')").matcher(sql);
        while (lm.find()) {
            literalsStartPositions.add(lm.start());
            literalsEndPositions.add(lm.end());
        }
        ArrayList<Integer> commentsStartPositions = new ArrayList<Integer>();
        ArrayList<Integer> commentsEndPositions = new ArrayList<Integer>();
        Matcher commentsm = Pattern.compile("--(.*?)\r?\n").matcher(sql);
        while (commentsm.find()) {
            if (!SQLParamExecutionListener.isNotInsideOfAnyLiteral(commentsm.start(), literalsStartPositions, literalsEndPositions)) continue;
            commentsStartPositions.add(commentsm.start());
            commentsEndPositions.add(commentsm.end());
        }
        StringBuffer strippedSql = new StringBuffer(sql);
        int commentStartIdx = -1;
        commentStartIdx = strippedSql.lastIndexOf("--");
        if (commentStartIdx != -1) {
            boolean uniqueComment = true;
            if (commentsEndPositions.size() > 0 && (Integer)commentsEndPositions.get(commentsEndPositions.size() - 1) > commentStartIdx) {
                uniqueComment = false;
            }
            if (uniqueComment && SQLParamExecutionListener.isNotInsideOfAnyLiteral(commentStartIdx, literalsStartPositions, literalsEndPositions)) {
                commentsStartPositions.add(commentStartIdx);
                commentsEndPositions.add(strippedSql.length());
            }
        }
        for (int i = commentsStartPositions.size() - 1; i >= 0; --i) {
            strippedSql = strippedSql.replace((Integer)commentsStartPositions.get(i), (Integer)commentsEndPositions.get(i), "");
        }
        return strippedSql.toString();
    }

    private static boolean isNotInsideOfAnyLiteral(int spos, List<Integer> literalsStartPositions, List<Integer> literalsEndPositions) {
        for (int i = 0; i < literalsStartPositions.size(); ++i) {
            if (literalsStartPositions.get(i) > spos || spos >= literalsEndPositions.get(i)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String testCase1 = "-- sql \n INSERT INTO code (txt) VALUES -- haha\n 'for(int i = e-1; i >= 0; --i)') -- nice test";
        System.out.println(SQLParamExecutionListener.removeComments(testCase1));
    }

    private void createParameterDialog(String parameter, String oldValue) {
        this.dialog = new AskParamValueDialog(parameter, oldValue, this.session.getApplication());
        this.session.getApplication().getMainFrame().addWidget((DialogWidget)this.dialog);
        this.dialog.setLayer(JLayeredPane.MODAL_LAYER);
        this.dialog.moveToFront();
        DialogWidget.centerWithinDesktop((DialogWidget)this.dialog);
        this.dialog.setVisible(true);
        this.dialog.requestFocusForInputField();
    }

    private String sanitizeValue(String value, boolean quoting) {
        String retValue = value;
        boolean quotesNeeded = quoting;
        try {
            Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            quotesNeeded = true;
        }
        if (quotesNeeded) {
            retValue = "'" + value + "'";
        }
        return retValue;
    }

    private boolean isQuoted(StringBuffer buffer, int position) {
        String part = buffer.substring(0, position);
        if (this.searchAllOccurences(part, "\"") % 2 != 0) {
            return true;
        }
        return this.searchAllOccurences(part, "'") % 2 != 0;
    }

    private int searchAllOccurences(String haystack, String needle) {
        int i = 0;
        int pos = 0;
        while ((pos = haystack.indexOf(needle, pos + 1)) > -1) {
            ++i;
        }
        return i;
    }
}

