/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class DialectUtils2 {
    public static String checkColumnDoubleQuotes(DialectType dialectType, String columnName) {
        if (DialectUtils2.shouldQuoteColumnName(dialectType, columnName)) {
            return "\"" + columnName + "\"";
        }
        return columnName;
    }

    private static boolean shouldQuoteColumnName(DialectType dialectType, String columnName) {
        if (dialectType == DialectType.HSQLDB || dialectType == DialectType.POSTGRES || dialectType == DialectType.H2) {
            return true;
        }
        if (!StringUtilities.isEmpty(columnName)) {
            if (!Character.isJavaIdentifierStart(columnName.charAt(0))) {
                return true;
            }
            for (int i = 1; i < columnName.length(); ++i) {
                char c = columnName.charAt(i);
                if (Character.isJavaIdentifierPart(c) && '.' != c && '$' != c) continue;
                return true;
            }
        }
        return false;
    }
}

