/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.properties;

import java.awt.Component;
import javax.swing.JScrollPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.INewSessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.ISessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SQLPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SessionSQLPropertiesPanel
implements INewSessionPropertiesPanel,
ISessionPropertiesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionSQLPropertiesPanel.class);
    private final IApplication _app;
    private final SQLPropertiesPanel _myPanel;
    private final JScrollPane _scrolledMyPanel;
    private SessionProperties _props;

    public SessionSQLPropertiesPanel(IApplication app, ISession session) throws IllegalArgumentException {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        this._app = app;
        this._myPanel = new SQLPropertiesPanel(app, session);
        this._scrolledMyPanel = new JScrollPane(this._myPanel);
        GUIUtils.forceScrollToBegin(this._scrolledMyPanel);
    }

    @Override
    public void initialize(IApplication app) {
        this._props = this._app.getSquirrelPreferences().getSessionProperties();
        this._myPanel.loadData(this._props);
    }

    @Override
    public void initialize(IApplication app, ISession session) throws IllegalArgumentException {
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this._props = session.getProperties();
        this._myPanel.loadData(this._props);
    }

    @Override
    public Component getPanelComponent() {
        return this._scrolledMyPanel;
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("SessionSQLPropertiesPanel.sql");
    }

    @Override
    public String getHint() {
        return this.getTitle();
    }

    @Override
    public void applyChanges() {
        this._myPanel.applyChanges(this._props);
    }
}

