/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class CancelPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CancelPanel.class);
    JLabel sqlLbl = new JLabel();
    JLabel currentStatusLbl = new JLabel();
    JButton cancelBtn;
    JButton closeBtn;
    JTextField txtExecTimeCounter;
    JTextField txtNumberOfRowsRead;

    public CancelPanel(ISession session) {
        super(new BorderLayout());
        this.add((Component)this.createNorthPanel(session), "North");
        this.add((Component)this.createCenterPanel(), "Center");
    }

    private JPanel createNorthPanel(ISession session) {
        JPanel ret = new JPanel(new BorderLayout());
        ImageIcon icon = session.getApplication().getResources().getIcon("close");
        this.closeBtn = new JButton(icon);
        this.closeBtn.setBorderPainted(false);
        this.closeBtn.setMargin(new Insets(0, 0, 0, 0));
        ret.add((Component)this.closeBtn, "East");
        ret.add((Component)new JPanel(), "Center");
        return ret;
    }

    private JPanel createCenterPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        String label = s_stringMgr.getString("SQLResultExecuterPanel.cancelButtonLabel");
        this.cancelBtn = new JButton(label);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        label = s_stringMgr.getString("SQLResultExecuterPanel.sqlLabel");
        ret.add((Component)new JLabel(label), gbc);
        gbc.weightx = 1.0;
        ++gbc.gridx;
        ret.add((Component)this.sqlLbl, gbc);
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        label = s_stringMgr.getString("SQLResultExecuterPanel.statusLabel");
        ret.add((Component)new JLabel(label), gbc);
        ++gbc.gridx;
        ret.add((Component)this.currentStatusLbl, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 0;
        ret.add((Component)this.cancelBtn, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.insets = new Insets(30, gbc.insets.left, gbc.insets.bottom, gbc.insets.right);
        gbc.gridwidth = 2;
        ret.add((Component)this.createExecutionTimePanel(), gbc);
        return ret;
    }

    private JPanel createExecutionTimePanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("SQLResultExecuterPanel.executingFor")), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.txtExecTimeCounter = new JTextField();
        this.txtExecTimeCounter.setEditable(false);
        this.txtExecTimeCounter.setColumns(10);
        GUIUtils.forceWidth(this.txtExecTimeCounter, 120);
        ret.add((Component)this.txtExecTimeCounter, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("SQLResultExecuterPanel.execMillis")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("SQLResultExecuterPanel.numberOfRowsRead")), gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        this.txtNumberOfRowsRead = new JTextField();
        this.txtNumberOfRowsRead.setEditable(false);
        this.txtNumberOfRowsRead.setColumns(10);
        GUIUtils.forceWidth(this.txtNumberOfRowsRead, 120);
        ret.add((Component)this.txtNumberOfRowsRead, gbc);
        return ret;
    }
}

