/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.reconnect;

import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.JdbcConnectionData;
import net.sourceforge.squirrel_sql.client.session.action.reconnect.ReconnectDialog;
import net.sourceforge.squirrel_sql.client.session.action.reconnect.ReconnectInfo;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class ReconnectController {
    public static final String PREF_KEY_RECONNECT_COLLAPSED = "Squirrel.reconnect.collapsed";
    private final ReconnectDialog _reconnectDialog = new ReconnectDialog();
    private final ReconnectInfo _reconnectInfo = new ReconnectInfo();

    public ReconnectController(ISession session) {
        JdbcConnectionData jdbcData = session.getJdbcData();
        this._reconnectDialog.txtUrl.setText(jdbcData.getUrl());
        this._reconnectDialog.txtUser.setText(jdbcData.getUser());
        this._reconnectDialog.txtPassword.setText(jdbcData.getPassword());
        if (Props.getBoolean(PREF_KEY_RECONNECT_COLLAPSED, true)) {
            this._reconnectDialog.collapse();
        } else {
            this._reconnectDialog.uncollapse();
            SwingUtilities.invokeLater(() -> this.prepareUrlTextField(this._reconnectDialog));
        }
        this._reconnectDialog.btnToggleCollapsed.addActionListener(e -> SwingUtilities.invokeLater(() -> this.prepareUrlTextField(this._reconnectDialog)));
        this._reconnectDialog.btnYes.addActionListener(e -> this.doReconnect(jdbcData));
        this._reconnectDialog.btnNo.addActionListener(e -> this.close());
        this._reconnectDialog.btnCancel.addActionListener(e -> this.close());
        GUIUtils.enableCloseByEscape(this._reconnectDialog);
        GUIUtils.centerWithinParent(this._reconnectDialog);
        this._reconnectDialog.setVisible(true);
        Props.putBoolean(PREF_KEY_RECONNECT_COLLAPSED, this._reconnectDialog.isCollapsed());
    }

    private void doReconnect(JdbcConnectionData jdbcData) {
        this._reconnectInfo.setReconnectRequested(true);
        if (!Utilities.equalsRespectNull(this._reconnectDialog.txtUrl.getText(), jdbcData.getUrl())) {
            this._reconnectInfo.setUrl(this._reconnectDialog.txtUrl.getText());
        }
        if (!Utilities.equalsRespectNull(this._reconnectDialog.txtUser.getText(), jdbcData.getUser())) {
            this._reconnectInfo.setUser(this._reconnectDialog.txtUrl.getText());
        }
        if (!Utilities.equalsRespectNull(new String(this._reconnectDialog.txtPassword.getPassword()), jdbcData.getPassword())) {
            this._reconnectInfo.setPassword(new String(this._reconnectDialog.txtPassword.getPassword()));
        }
        this.close();
    }

    private void close() {
        this._reconnectDialog.setVisible(false);
        this._reconnectDialog.dispose();
    }

    private void prepareUrlTextField(ReconnectDialog reconnectDialog) {
        reconnectDialog.txtUrl.requestFocus();
        if (StringUtilities.isEmpty(reconnectDialog.txtUrl.getText())) {
            reconnectDialog.txtUrl.setCaretPosition(reconnectDialog.txtUrl.getText().length());
        }
    }

    public ReconnectInfo getReconnectInfo() {
        return this._reconnectInfo;
    }
}

