/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.SmallTabButton;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ButtonTabComponent
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ButtonTabComponent.class);
    private JTabbedPane _tabbedPane;
    private JLabel _label = new JLabel();
    private CloseTabButton _btnClose;
    private JPanel _pnlSmallTabButtons;
    private final SmallTabButton _btnToWindow;
    private Font _defaultFont = null;
    private Font _selectedFont = null;
    private Color _foregroundColor = null;

    public ButtonTabComponent(String title) {
        this(title, null);
    }

    public ButtonTabComponent(String title, Icon icon) {
        this(null, title, icon);
    }

    public ButtonTabComponent(JTabbedPane tabbedPane, String title, Icon icon) {
        this._tabbedPane = tabbedPane;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setOpaque(false);
        this._btnClose = new CloseTabButton(this);
        this.add(this._btnClose);
        this._label.setText(title);
        this._label.setOpaque(false);
        if (null != icon) {
            this._label.setIcon(icon);
        }
        this.initLabelDefaults();
        this.add(this._label);
        this._label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this._pnlSmallTabButtons = new JPanel(new FlowLayout(0, 2, 0));
        this._pnlSmallTabButtons.setOpaque(false);
        this.add(this._pnlSmallTabButtons);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this._btnToWindow = new SmallTabButton(s_stringMgr.getString("docktabdesktop.ButtonTabComponent.detachButtonTooltip"), Main.getApplication().getResources().getIcon("tabDetachSmall"));
        this._pnlSmallTabButtons.add(this._btnToWindow);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.initLabelDefaults();
    }

    private void initLabelDefaults() {
        if (this._label != null) {
            this._defaultFont = this._label.getFont().deriveFont(-2);
            this._selectedFont = this._label.getFont().deriveFont(1);
            this._foregroundColor = null != this._tabbedPane ? this.getForegroundColor(this._tabbedPane) : this.getForegroundColor(UIFactory.getInstance().createTabbedPane());
        }
    }

    private Color getForegroundColor(JTabbedPane tabbedPane) {
        Color ret = UIManager.getColor("TabbedPane.selectedForeground");
        if (ret == null) {
            ret = tabbedPane.getForeground();
        }
        return ret;
    }

    private int getMyTabIndex() {
        if (null != this._tabbedPane) {
            for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
                if (!this.equals(this._tabbedPane.getTabComponentAt(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void paint(Graphics g) {
        int tabIndex = this.getMyTabIndex();
        if (tabIndex >= 0) {
            if (tabIndex == this._tabbedPane.getSelectedIndex()) {
                this._label.setFont(this._selectedFont);
                if (this._tabbedPane.getForegroundAt(tabIndex) instanceof ColorUIResource) {
                    this._label.setForeground(this._foregroundColor);
                } else {
                    this._label.setForeground(this._tabbedPane.getForegroundAt(tabIndex));
                }
            } else {
                this._label.setFont(this._defaultFont);
                this._label.setForeground(this._tabbedPane.getForegroundAt(tabIndex));
            }
        }
        super.paint(g);
    }

    public JButton getClosebutton() {
        return this._btnClose;
    }

    public JButton getToWindowButton() {
        return this._btnToWindow;
    }

    public void setIcon(Icon icon) {
        this._label.setIcon(icon);
    }

    public void setTitle(String title) {
        this._label.setText(title);
    }

    public String getTitle() {
        return this._label.getText();
    }

    public void addSmallTabButton(SmallTabButton smallTabButton) {
        for (Component component : this._pnlSmallTabButtons.getComponents()) {
            if (component != smallTabButton) continue;
            return;
        }
        this._pnlSmallTabButtons.add(smallTabButton);
    }

    public void removeSmallTabButton(SmallTabButton smallTabButton) {
        this._pnlSmallTabButtons.remove(smallTabButton);
    }

    public ArrayList<SmallTabButton> getExternalButtons() {
        this._pnlSmallTabButtons.getComponents();
        ArrayList<SmallTabButton> ret = new ArrayList<SmallTabButton>();
        for (Component cp : this._pnlSmallTabButtons.getComponents()) {
            if (!(cp instanceof SmallTabButton) || cp == this._btnToWindow) continue;
            ret.add((SmallTabButton)cp);
        }
        return ret;
    }

    public SmallTabButton findSmallTabButtonByUserObject(Object userObject) {
        for (Component cp : this._pnlSmallTabButtons.getComponents()) {
            SmallTabButton stb = (SmallTabButton)cp;
            if (userObject != stb.getUserObject()) continue;
            return stb;
        }
        return null;
    }

    public void doClickClose() {
        this._btnClose.doClick();
    }

    private static class CloseTabButton
    extends SmallTabButton {
        private ButtonTabComponent tabComponent;

        private CloseTabButton(ButtonTabComponent tabComponent) {
            super(s_stringMgr.getString("docktabdesktop.ButtonTabComponent.toolTip"), null);
            this.tabComponent = tabComponent;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(new BasicStroke(2.0f));
            if (this.getModel().isRollover()) {
                g2.setColor(Color.MAGENTA);
            } else {
                g2.setColor(this.tabComponent._foregroundColor);
            }
            int delta = 6;
            g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            g2.dispose();
        }
    }
}

