/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.DataCache;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.util.IdentifierFactory;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifierFactory;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class AliasWindowFactory
implements AliasInternalFrame.IMaintenanceType {
    private static final ILogger s_log = LoggerController.createLogger(AliasWindowFactory.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasWindowFactory.class);
    private static Map<IIdentifier, AliasInternalFrame> _modifySheets = new HashMap<IIdentifier, AliasInternalFrame>();

    public static AliasInternalFrame getModifySheet(ISQLAlias alias) {
        AliasInternalFrame sheet = _modifySheets.get(alias.getIdentifier());
        if (sheet == null) {
            sheet = new AliasInternalFrame(Main.getApplication(), alias, 2);
            _modifySheets.put(alias.getIdentifier(), sheet);
            Main.getApplication().getMainFrame().addWidget(sheet);
            sheet.addWidgetListener(new WidgetAdapter(){

                @Override
                public void widgetClosed(WidgetEvent evt) {
                    AliasInternalFrame frame = (AliasInternalFrame)evt.getWidget();
                    _modifySheets.remove(frame.getSQLAlias().getIdentifier());
                }
            });
            AliasWindowFactory.initAliasWidgetListener(sheet);
            DialogWidget.centerWithinDesktop(sheet);
        }
        return sheet;
    }

    private static void initAliasWidgetListener(final AliasInternalFrame sheet) {
        sheet.addWidgetListener(new WidgetAdapter(){

            @Override
            public void widgetClosed(WidgetEvent evt) {
                Main.getApplication().getWindowManager().getAliasesListInternalFrame().getAliasesList().aliasChanged(sheet.getSQLAlias());
            }
        });
    }

    public static AliasInternalFrame getCreateSheet() {
        DataCache cache = Main.getApplication().getDataCache();
        IIdentifierFactory factory = IdentifierFactory.getInstance();
        SQLAlias alias = cache.createAlias(factory.createIdentifier());
        AliasInternalFrame sheet = new AliasInternalFrame(Main.getApplication(), alias, 1);
        Main.getApplication().getMainFrame().addWidget(sheet);
        DialogWidget.centerWithinDesktop(sheet);
        AliasWindowFactory.initAliasWidgetListener(sheet);
        return sheet;
    }

    public static AliasInternalFrame getCopySheet(SQLAlias alias) {
        DataCache cache = Main.getApplication().getDataCache();
        IIdentifierFactory factory = IdentifierFactory.getInstance();
        SQLAlias newAlias = cache.createAlias(factory.createIdentifier());
        try {
            newAlias.assignFrom(alias, false);
            if (2 == newAlias.getSchemaProperties().getGlobalState()) {
                Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("AliasWindowFactory.schemaPropsCopiedWarning"));
            }
            Main.getApplication().getPluginManager().aliasCopied(alias, newAlias);
        }
        catch (ValidationException ex) {
            s_log.error(s_stringMgr.getString("AliasWindowFactory.error.copyAlias"), ex);
        }
        AliasInternalFrame sheet = new AliasInternalFrame(Main.getApplication(), newAlias, 3);
        Main.getApplication().getMainFrame().addWidget(sheet);
        DialogWidget.centerWithinDesktop(sheet);
        AliasWindowFactory.initAliasWidgetListener(sheet);
        return sheet;
    }
}

