/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.preferences.INewSessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanelFactory;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.client.session.properties.ISessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.shortcut.ShortcutUtil;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.syntax.AutoCorrectProviderImpl;
import net.sourceforge.squirrel_sql.plugins.syntax.CommentAction;
import net.sourceforge.squirrel_sql.plugins.syntax.CommentActionAltAccelerator;
import net.sourceforge.squirrel_sql.plugins.syntax.ConfigureAutoCorrectAction;
import net.sourceforge.squirrel_sql.plugins.syntax.DuplicateLineAction;
import net.sourceforge.squirrel_sql.plugins.syntax.FindAction;
import net.sourceforge.squirrel_sql.plugins.syntax.FindSelectedAction;
import net.sourceforge.squirrel_sql.plugins.syntax.GoToLineAction;
import net.sourceforge.squirrel_sql.plugins.syntax.MarkSelectedAction;
import net.sourceforge.squirrel_sql.plugins.syntax.RepeatLastFindAction;
import net.sourceforge.squirrel_sql.plugins.syntax.ReplaceAction;
import net.sourceforge.squirrel_sql.plugins.syntax.SQLEntryPanelFactoryProxy;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPluginResources;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPrefChangeNotSupportedException;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferencesPanel;
import net.sourceforge.squirrel_sql.plugins.syntax.ToolsPopupHandler;
import net.sourceforge.squirrel_sql.plugins.syntax.UncommentAction;
import net.sourceforge.squirrel_sql.plugins.syntax.UncommentActionAltAccelerator;
import net.sourceforge.squirrel_sql.plugins.syntax.UnmarkAction;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.RSyntaxSQLEntryPanel;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirreLRSyntaxTextAreaUI;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.action.SquirrelCopyAsRtfAction;

public class SyntaxPlugin
extends DefaultSessionPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SyntaxPlugin.class);
    private static final ILogger s_log = LoggerController.createLogger(SyntaxPlugin.class);
    private SyntaxPreferences _newSessionPrefs;
    private FileWrapper _userSettingsFolder;
    private SQLEntryPanelFactoryProxy _sqlEntryFactoryProxy;
    private Map<IIdentifier, SessionPreferencesListener> _prefListeners = new HashMap<IIdentifier, SessionPreferencesListener>();
    private SyntaxPluginResources _resources;
    private AutoCorrectProviderImpl _autoCorrectProvider;

    public String getInternalName() {
        return "syntax";
    }

    public String getDescriptiveName() {
        return "Syntax Highlighting Plugin";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getAuthor() {
        return "Gerd Wagner, Colin Bell";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        this._resources = new SyntaxPluginResources((IPlugin)this);
        try {
            this._userSettingsFolder = this.getPluginUserSettingsFolder();
        }
        catch (IOException ex) {
            throw new PluginException((Exception)ex);
        }
        this.loadPrefs();
        IApplication app = this.getApplication();
        ISQLEntryPanelFactory originalFactory = app.getSQLEntryPanelFactory();
        this._sqlEntryFactoryProxy = new SQLEntryPanelFactoryProxy(this, originalFactory);
        app.setSQLEntryPanelFactory((ISQLEntryPanelFactory)this._sqlEntryFactoryProxy);
        this._autoCorrectProvider = new AutoCorrectProviderImpl(this._userSettingsFolder);
        this.createMenu();
        this.createAdditionalActions();
        this.preRegisterShortcuts();
    }

    private void preRegisterShortcuts() {
        SquirreLRSyntaxTextAreaUI.getToUpperCaseKeyStroke();
        SquirreLRSyntaxTextAreaUI.getToLowerCaseKeyStroke();
        SquirreLRSyntaxTextAreaUI.getLineUpKeyStroke();
        SquirreLRSyntaxTextAreaUI.getLineDownKeyStroke();
    }

    private void createAdditionalActions() {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new SquirrelCopyAsRtfAction((IResources)this._resources)));
    }

    private void createMenu() {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        JMenu menu = this._resources.createMenu("syntax");
        app.addToMenu(2, menu);
        SquirrelAction act = new ConfigureAutoCorrectAction(app, this._resources, this);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new FindAction(this.getApplication(), this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new FindSelectedAction(this.getApplication(), this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new RepeatLastFindAction(this.getApplication(), this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new MarkSelectedAction(this.getApplication(), this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new ReplaceAction(this.getApplication(), this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new UnmarkAction(this.getApplication(), this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new GoToLineAction(this.getApplication(), this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new DuplicateLineAction(this.getApplication(), this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new CommentAction(this.getApplication(), this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new CommentActionAltAccelerator(this.getApplication(), this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new UncommentAction(this.getApplication(), this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
        act = new UncommentActionAltAccelerator(this.getApplication(), this._resources);
        coll.add((Action)act);
        this._resources.addToMenu((Action)act, menu);
    }

    public void unload() {
        this.savePrefs();
        super.unload();
    }

    public void sessionCreated(ISession session) {
        SyntaxPreferences prefs = null;
        try {
            prefs = (SyntaxPreferences)this._newSessionPrefs.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("CloneNotSupportedException for SyntaxPreferences");
        }
        session.putPluginObject((IPlugin)this, "prefs", (Object)prefs);
        SessionPreferencesListener lis = new SessionPreferencesListener(this, session);
        prefs.addPropertyChangeListener(lis);
        this._prefListeners.put(session.getIdentifier(), lis);
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        PluginSessionCallback ret = new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
                SyntaxPlugin.this.initSqlInternalFrame(sqlInternalFrame);
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
            }

            public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
                SyntaxPlugin.this.initSqlPanel(additionalSQLTab.getSQLPanelAPI());
            }
        };
        this.initSessionSheet(session);
        return ret;
    }

    public SyntaxPreferences getSyntaxPreferences() {
        return this._newSessionPrefs;
    }

    private void initSessionSheet(ISession session) {
        ActionCollection coll = this.getApplication().getActionCollection();
        session.addSeparatorToToolbar();
        session.addToToolbar(coll.get(FindAction.class));
        session.addToToolbar(coll.get(ReplaceAction.class));
        session.addToToolbar(coll.get(ConfigureAutoCorrectAction.class));
        this.initSqlPanel(session.getSessionInternalFrame().getMainSQLPanelAPI());
    }

    private void initSqlInternalFrame(SQLInternalFrame sqlInternalFrame) {
        ActionCollection coll = this.getApplication().getActionCollection();
        FindAction findAction = (FindAction)((Object)coll.get(FindAction.class));
        ReplaceAction replaceAction = (ReplaceAction)((Object)coll.get(ReplaceAction.class));
        sqlInternalFrame.addSeparatorToToolbar();
        sqlInternalFrame.addToToolbar((Action)((Object)findAction));
        sqlInternalFrame.addToToolbar((Action)((Object)replaceAction));
        sqlInternalFrame.addToToolbar(coll.get(ConfigureAutoCorrectAction.class));
        this.initSqlPanel(sqlInternalFrame.getMainSQLPanelAPI());
    }

    private void initSqlPanel(ISQLPanelAPI sqlPanelAPI) {
        ActionCollection coll = Main.getApplication().getActionCollection();
        new ToolsPopupHandler(this).initToolsPopup(coll, sqlPanelAPI);
        this.completeSqlPanelEntryAreaMenu(coll, sqlPanelAPI);
    }

    private void completeSqlPanelEntryAreaMenu(ActionCollection coll, ISQLPanelAPI sqlPanelAPI) {
        JMenuItem mnuUnmark = sqlPanelAPI.addToSQLEntryAreaMenu(coll.get(UnmarkAction.class));
        this._resources.configureMenuItem(coll.get(UnmarkAction.class), mnuUnmark);
        JMenuItem mnuComment = sqlPanelAPI.addToSQLEntryAreaMenu(coll.get(CommentAction.class));
        this._resources.configureMenuItem(coll.get(CommentAction.class), mnuComment);
        JMenuItem mnuCommentAltAccelerator = sqlPanelAPI.addToSQLEntryAreaMenu(coll.get(CommentActionAltAccelerator.class));
        this._resources.configureMenuItem(coll.get(CommentActionAltAccelerator.class), mnuCommentAltAccelerator);
        mnuCommentAltAccelerator.setVisible(false);
        JMenuItem mnuUncomment = sqlPanelAPI.addToSQLEntryAreaMenu(coll.get(UncommentAction.class));
        this._resources.configureMenuItem(coll.get(UncommentAction.class), mnuUncomment);
        JMenuItem mnuUncommentAltAccelerator = sqlPanelAPI.addToSQLEntryAreaMenu(coll.get(UncommentActionAltAccelerator.class));
        this._resources.configureMenuItem(coll.get(UncommentActionAltAccelerator.class), mnuUncommentAltAccelerator);
        mnuUncommentAltAccelerator.setVisible(false);
        if (sqlPanelAPI.getSQLEntryPanel().getTextComponent() instanceof SquirrelRSyntaxTextArea) {
            JMenuItem mnuCopyToRtf = sqlPanelAPI.addToSQLEntryAreaMenu(coll.get(SquirrelCopyAsRtfAction.class));
            this._resources.configureMenuItem(coll.get(SquirrelCopyAsRtfAction.class), mnuCopyToRtf);
            SquirrelRSyntaxTextArea rsEdit = (SquirrelRSyntaxTextArea)((Object)sqlPanelAPI.getSQLEntryPanel().getTextComponent());
            this.configureRichTextAction(sqlPanelAPI, rsEdit, "RTA.UpperCaseAction", SquirreLRSyntaxTextAreaUI.getToUpperCaseKeyStroke(), s_stringMgr.getString("SyntaxPlugin.ToUpperShortDescription"));
            this.configureRichTextAction(sqlPanelAPI, rsEdit, "RTA.LowerCaseAction", SquirreLRSyntaxTextAreaUI.getToLowerCaseKeyStroke(), s_stringMgr.getString("SyntaxPlugin.ToLowerShortDescription"));
            this.configureRichTextAction(sqlPanelAPI, rsEdit, "RTA.LineUpAction", SquirreLRSyntaxTextAreaUI.getLineUpKeyStroke(), s_stringMgr.getString("SyntaxPlugin.LineUpShortDescription"));
            this.configureRichTextAction(sqlPanelAPI, rsEdit, "RTA.LineDownAction", SquirreLRSyntaxTextAreaUI.getLineDownKeyStroke(), s_stringMgr.getString("SyntaxPlugin.LineDownShortDescription"));
        }
    }

    private void configureRichTextAction(ISQLPanelAPI sqlPanelAPI, SquirrelRSyntaxTextArea rsEdit, String rtaKey, KeyStroke acceleratorKeyStroke, String shortDescription) {
        Action action = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, rtaKey);
        action.putValue("SQuirreLAcceleratorString", ShortcutUtil.getKeystrokeString((KeyStroke)acceleratorKeyStroke));
        action.putValue("ShortDescription", shortDescription);
        action.putValue("MnemonicKey", 0);
        action.putValue("AcceleratorKey", acceleratorKeyStroke);
        JMenuItem mnu = sqlPanelAPI.addToSQLEntryAreaMenu(action);
        mnu.setText((String)action.getValue("ShortDescription"));
        this._resources.configureMenuItem(action, mnu, true);
    }

    public void sessionEnding(ISession session) {
        super.sessionEnding(session);
        session.removePluginObject((IPlugin)this, "prefs");
        this._prefListeners.remove(session.getIdentifier());
        this._sqlEntryFactoryProxy.sessionEnding(session);
    }

    public INewSessionPropertiesPanel[] getNewSessionPropertiesPanels() {
        return new INewSessionPropertiesPanel[]{new SyntaxPreferencesPanel(this._newSessionPrefs, this._resources)};
    }

    public ISessionPropertiesPanel[] getSessionPropertiesPanels(ISession session) {
        SyntaxPreferences sessionPrefs = (SyntaxPreferences)session.getPluginObject((IPlugin)this, "prefs");
        return new ISessionPropertiesPanel[]{new SyntaxPreferencesPanel(sessionPrefs, this._resources)};
    }

    public SyntaxPluginResources getResources() {
        return this._resources;
    }

    ISQLEntryPanelFactory getSQLEntryAreaFactory() {
        return this._sqlEntryFactoryProxy;
    }

    private void loadPrefs() {
        try {
            XMLBeanReader doc = new XMLBeanReader();
            FileWrapper file = this.fileWrapperFactory.create(this._userSettingsFolder, "prefs.xml");
            doc.load(file, ((Object)((Object)this)).getClass().getClassLoader());
            Iterator it = doc.iterator();
            if (it.hasNext()) {
                this._newSessionPrefs = (SyntaxPreferences)it.next();
            }
        }
        catch (FileNotFoundException doc) {
        }
        catch (Exception ex) {
            String msg = "Error occurred reading from preferences file: prefs.xml";
            s_log.error((Object)"Error occurred reading from preferences file: prefs.xml", (Throwable)ex);
        }
        if (this._newSessionPrefs == null) {
            this._newSessionPrefs = new SyntaxPreferences();
        }
    }

    private void savePrefs() {
        try {
            XMLBeanWriter wtr = new XMLBeanWriter((Object)this._newSessionPrefs);
            wtr.save(this.fileWrapperFactory.create(this._userSettingsFolder, "prefs.xml"));
        }
        catch (Exception ex) {
            String msg = "Error occurred writing to preferences file: prefs.xml";
            s_log.error((Object)"Error occurred writing to preferences file: prefs.xml", (Throwable)ex);
        }
    }

    public Object getExternalService() {
        return this.getAutoCorrectProviderImpl();
    }

    public AutoCorrectProviderImpl getAutoCorrectProviderImpl() {
        return this._autoCorrectProvider;
    }

    private static final class SessionPreferencesListener
    implements PropertyChangeListener {
        private SyntaxPlugin _plugin;
        private ISession _session;

        SessionPreferencesListener(SyntaxPlugin plugin, ISession session) {
            this._plugin = plugin;
            this._session = session;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (!"useRSyntaxControl".equals(propName)) {
                Object pluginObject = this._session.getPluginObject((IPlugin)this._plugin, "sqlentry");
                if (pluginObject instanceof RSyntaxSQLEntryPanel) {
                    ((RSyntaxSQLEntryPanel)((Object)pluginObject)).updateFromPreferences();
                }
            } else {
                String msg = s_stringMgr.getString("syntax.switchingNotSupported");
                JOptionPane.showMessageDialog((Component)this._session.getApplication().getMainFrame(), msg);
                throw new SyntaxPrefChangeNotSupportedException();
            }
        }
    }

    private static interface IMenuResourceKeys {
        public static final String MENU = "syntax";
    }

    static interface i18n {
        public static final String TO_UPPER_CASE = SyntaxPlugin.access$000().getString("SyntaxPlugin.touppercase");
        public static final String TO_LOWER_CASE = SyntaxPlugin.access$000().getString("SyntaxPlugin.tolowercase");
        public static final String FIND = SyntaxPlugin.access$000().getString("SyntaxPlugin.find");
        public static final String FIND_SELECTED = SyntaxPlugin.access$000().getString("SyntaxPlugin.findselected");
        public static final String REPEAT_LAST_FIND = SyntaxPlugin.access$000().getString("SyntaxPlugin.repeatLastFind");
        public static final String MARK_SELECTED = SyntaxPlugin.access$000().getString("SyntaxPlugin.markSelected");
        public static final String REPLACE = SyntaxPlugin.access$000().getString("SyntaxPlugin.replace");
        public static final String UNMARK = SyntaxPlugin.access$000().getString("SyntaxPlugin.unmark");
        public static final String GO_TO_LINE = SyntaxPlugin.access$000().getString("SyntaxPlugin.gotoline");
        public static final String AUTO_CORR = SyntaxPlugin.access$000().getString("SyntaxPlugin.autocorr");
        public static final String DUP_LINE = SyntaxPlugin.access$000().getString("SyntaxPlugin.duplicateline");
        public static final String COMMENT = SyntaxPlugin.access$000().getString("SyntaxPlugin.comment");
        public static final String UNCOMMENT = SyntaxPlugin.access$000().getString("SyntaxPlugin.uncomment");
        public static final String COPY_AS_RTF = SyntaxPlugin.access$000().getString("SyntaxPlugin.copyasrtf");
    }
}

