/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.io.FileManager;
import unity.jdbc.UnityDriver;
import unity.operators.Operator;

public class FileScan
extends Operator {
    private static final long serialVersionUID = 1L;
    protected String inFileName;
    protected BufferedInputStream inFile;
    protected Relation inputRelation;

    public FileScan(String string, Relation relation) {
        this.inFileName = string;
        this.inputRelation = relation;
        this.setOutputRelation(relation);
    }

    @Override
    public void init() throws SQLException {
        try {
            this.inFile = FileManager.openInputFile(this.inFileName);
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        if (!tuple.read(this.inFile)) {
            return false;
        }
        this.incrementRowsOut();
        this.incrementIOBytes(tuple.getBytes().length);
        return true;
    }

    @Override
    public void close() throws SQLException {
        try {
            FileManager.closeFile(this.inFile);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("FILE SCAN: (FileName=" + this.inFileName + ")");
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return "FILE SCAN";
    }

    @Override
    public String getDescription() {
        return UnityDriver.i18n.getString("FileScan.Description");
    }
}

