/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Aggregate_Function;
import unity.functions.Expression;

public class A_Avg
extends Aggregate_Function {
    private static final long serialVersionUID = 1L;
    protected double currentTotal;
    protected long currentTotalLong;
    protected long currentCount;
    protected boolean isIntType;
    protected BigDecimal totalDecimal;
    protected boolean isBigDecimal;

    public A_Avg(Expression expression) {
        this.children = new ArrayList(1);
        this.children.add(expression);
        this.computedExpr = expression;
        this.returnType = expression.getReturnType();
        this.isIntType = this.returnType == 4 || this.returnType == -5;
        this.isBigDecimal = false;
        this.totalDecimal = new BigDecimal(0);
    }

    @Override
    public void reset() {
        this.currentTotal = 0.0;
        this.currentTotalLong = 0L;
        this.currentCount = 0L;
        this.totalDecimal = new BigDecimal(0);
    }

    @Override
    public Object compute() {
        if (this.currentCount == 0L) {
            return null;
        }
        if (this.isIntType) {
            return new Double((double)this.currentTotalLong * 1.0 / (double)this.currentCount);
        }
        if (this.isBigDecimal) {
            return new BigDecimal(this.totalDecimal.divide(new BigDecimal(this.currentCount)).toString());
        }
        return new Double(this.currentTotal / (double)this.currentCount);
    }

    @Override
    public void add(Tuple tuple) throws SQLException {
        Object object = this.computedExpr.evaluate(tuple);
        if (object != null) {
            if (this.isIntType) {
                this.currentTotalLong += ((Number)object).longValue();
            } else if (object instanceof String || object instanceof BigDecimal) {
                this.totalDecimal = this.totalDecimal.add(new BigDecimal(object.toString()));
                this.isBigDecimal = true;
            } else {
                this.currentTotal += ((Number)object).doubleValue();
            }
            ++this.currentCount;
        }
    }

    @Override
    public String toString(Relation relation, Attribute attribute) {
        return "AVG(" + this.computedExpr.toString(relation) + ") AS " + attribute.getName();
    }
}

