from mercurial.node import hex
from mercurial import bookmarks


def sgbookmarks(ui, repo):
    ctx = repo[None]
    parents = [p for p in ctx.parents() if p.rev() >= 0]

    marks = bookmarks.bmstore(repo)
    try:
        curMark = bookmarks.readactive(repo)
    except AttributeError:
        curMark = bookmarks.readcurrent(repo)

    ui.write('active\t', curMark if curMark is not None else '', '\n')
    ui.write('heads\t', len(parents), '\n')
    for p in parents:
        ui.write(hex(p.node()), '\n')

    ui.write('bookmarks\t', len(marks), '\n')
    for bmark, n in sorted(marks.iteritems()):
        ui.write(bmark, '\t', repo.changelog.rev(n), '\t', hex(repo[n].node()), '\n')


cmdtable = {
    'sgbookmarks': (sgbookmarks, [])
}
