/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNFileFetcher;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNAmbientDepthFilterEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExportEditor;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNUpdateClient16
extends SVNBasicDelegate {
    private ISVNExternalsHandler myExternalsHandler;
    private boolean myIsUpdateLocksOnDemand;
    private boolean myIsExportExpandsKeywords;

    public SVNUpdateClient16(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
        this.setExportExpandsKeywords(true);
        this.setExternalsHandler(ISVNExternalsHandler.DEFAULT);
    }

    public SVNUpdateClient16(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
        this.setExportExpandsKeywords(true);
        this.setExternalsHandler(ISVNExternalsHandler.DEFAULT);
    }

    public void setExternalsHandler(ISVNExternalsHandler externalsHandler) {
        if (externalsHandler == null) {
            externalsHandler = ISVNExternalsHandler.DEFAULT;
        }
        this.myExternalsHandler = externalsHandler;
    }

    public ISVNExternalsHandler getExternalsHandler() {
        return this.myExternalsHandler;
    }

    public long doUpdate(File file, SVNRevision revision, boolean recursive) throws SVNException {
        return this.doUpdate(file, revision, SVNDepth.fromRecurse(recursive), false, false);
    }

    public long doUpdate(File file, SVNRevision revision, boolean recursive, boolean force) throws SVNException {
        return this.doUpdate(file, revision, SVNDepth.fromRecurse(recursive), force, false);
    }

    public long[] doUpdate(File[] paths, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SVNException {
        if (paths == null) {
            return new long[0];
        }
        LinkedList<Long> revisions = new LinkedList<Long>();
        for (int i = 0; i < paths.length; ++i) {
            this.checkCancelled();
            File path = paths[i];
            try {
                this.setEventPathPrefix("");
                this.handlePathListItem(path);
                long rev = this.doUpdate(path, revision, depth, allowUnversionedObstructions, depthIsSticky);
                revisions.add(new Long(rev));
                continue;
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                    SVNEvent skipEvent = SVNEventFactory.createSVNEvent(path, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.SKIP, SVNEventAction.UPDATE_COMPLETED, null, null);
                    this.dispatchEvent(skipEvent);
                    revisions.add(new Long(-1L));
                    continue;
                }
                throw svne;
            }
            finally {
                this.setEventPathPrefix(null);
            }
        }
        this.sleepForTimeStamp();
        long[] result = new long[revisions.size()];
        int i = 0;
        for (Long value : revisions) {
            result[i++] = value;
        }
        return result;
    }

    public long doUpdate(File path, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SVNException {
        return this.update(path, revision, depth, allowUnversionedObstructions, depthIsSticky, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doSwitchImpl(SVNWCAccess wcAccess, File path, SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SVNException {
        SVNErrorMessage err;
        if (!SVNWCUtil.isVersionedDirectory(path.isDirectory() ? path : path.getParentFile())) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' does not appear to be a working copy path", (Object)path);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (depth == SVNDepth.UNKNOWN) {
            depthIsSticky = false;
        }
        if (depthIsSticky && depth == SVNDepth.EXCLUDE) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot both exclude and switch a path");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        boolean closeAccess = wcAccess == null;
        try {
            SVNEntry targetEntry;
            SVNAdminAreaInfo info = null;
            if (wcAccess != null) {
                try (SVNWCAccess tmpAccess = null;){
                    tmpAccess = this.createWCAccess();
                    info = tmpAccess.openAnchor(path, false, -1);
                }
                SVNAdminArea anchor = info.getAnchor();
                SVNAdminArea target = info.getTarget();
                anchor = wcAccess.retrieve(anchor.getRoot());
                target = wcAccess.retrieve(target.getRoot());
                info.setAnchor(anchor);
                info.setTarget(target);
                info.setWCAccess(wcAccess);
            } else {
                wcAccess = this.createWCAccess();
                info = wcAccess.openAnchor(path, true, -1);
            }
            SVNReporter reporter = new SVNReporter(info, path, true, false, depth, false, false, !depthIsSticky, this.getDebugLog());
            SVNAdminArea anchorArea = info.getAnchor();
            SVNEntry entry = anchorArea.getVersionedEntry(anchorArea.getThisDirName(), false);
            SVNURL sourceURL = entry.getSVNURL();
            if (sourceURL == null) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Directory ''{0}'' has no URL", (Object)anchorArea.getRoot());
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            long[] revs = new long[1];
            SVNRepository repository = this.createRepository(url, null, anchorArea, pegRevision, revision, revs);
            long revNumber = revs[0];
            url = repository.getLocation();
            SVNURL sourceRoot = repository.getRepositoryRoot(true);
            if (!SVNPathUtil.isAncestor(sourceRoot.toString(), sourceURL.toString())) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SWITCH, "''{0}''\nis not the same repository as\n''{1}''", sourceURL.toString(), sourceRoot.toString());
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            if (depthIsSticky && depth.compareTo(SVNDepth.INFINITY) < 0 && (targetEntry = anchorArea.getEntry(info.getTargetName(), true)) != null && targetEntry.isDirectory()) {
                SVNWCManager.crop(info, depth);
            }
            repository.setLocation(sourceURL, false);
            String[] preservedExts = this.getOptions().getPreservedConflictFileExtensions();
            ISVNUpdateEditor editor = wcAccess.createUpdateEditor(info, url.toString(), allowUnversionedObstructions, depthIsSticky, depth, preservedExts, null, false);
            ISVNEditor filterEditor = SVNAmbientDepthFilterEditor.wrap(editor, info, depthIsSticky);
            String target = "".equals(info.getTargetName()) ? null : info.getTargetName();
            repository.update(url, revNumber, target, depth, (ISVNReporterBaton)reporter, SVNCancellableEditor.newInstance(filterEditor, this, this.getDebugLog()));
            long targetRevision = editor.getTargetRevision();
            if (targetRevision >= 0L && !this.isIgnoreExternals() && depth.isRecursive()) {
                url = target == null ? url : url.removePathTail();
                this.handleExternals(wcAccess, info.getAnchor().getRoot(), info.getOldExternals(), info.getNewExternals(), info.getDepths(), url, sourceRoot, depth, false, true);
            }
            this.dispatchEvent(SVNEventFactory.createSVNEvent(info.getTarget().getRoot(), SVNNodeKind.NONE, null, targetRevision, SVNEventAction.UPDATE_COMPLETED, null, null, null, reporter.getReportedFilesCount(), reporter.getTotalFilesCount()));
            long l = targetRevision;
            return l;
        }
        finally {
            if (closeAccess) {
                wcAccess.close();
            }
            this.sleepForTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long update(File path, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky, boolean sendCopyFrom) throws SVNException {
        SVNDepth sVNDepth = depth = depth == null ? SVNDepth.UNKNOWN : depth;
        if (depth == SVNDepth.UNKNOWN) {
            depthIsSticky = false;
        }
        path = path.getAbsoluteFile();
        SVNWCAccess wcAccess = this.createWCAccess();
        SVNAdminAreaInfo adminInfo = null;
        int admOpenDepth = depthIsSticky ? -1 : this.getLevelsToLockFromDepth(depth);
        try {
            SVNEntry targetEntry;
            SVNAdminArea anchorArea;
            SVNEntry entry;
            SVNURL url;
            if (this.isUpdateLocksOnDemand()) {
                wcAccess.openAnchor(path, true, 0);
                wcAccess.close();
            }
            if ((url = (entry = (anchorArea = (adminInfo = wcAccess.openAnchor(path, !this.isUpdateLocksOnDemand(), admOpenDepth)).getAnchor()).getEntry(anchorArea.getThisDirName(), false)).getSVNURL()) == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry ''{0}'' has no URL", (Object)anchorArea.getRoot());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (depthIsSticky && depth.compareTo(SVNDepth.INFINITY) < 0 && (targetEntry = anchorArea.getEntry(adminInfo.getTargetName(), true)) != null && targetEntry.isDirectory()) {
                SVNWCManager.crop(adminInfo, depth);
                if (depth == SVNDepth.EXCLUDE) {
                    long l = -1L;
                    return l;
                }
            }
            String[] preservedExts = this.getOptions().getPreservedConflictFileExtensions();
            SVNRepository repos = this.createRepository(url, anchorArea.getRoot(), wcAccess, true);
            boolean serverSupportsDepth = repos.hasCapability(SVNCapability.DEPTH);
            SVNReporter reporter = new SVNReporter(adminInfo, path, true, !serverSupportsDepth, depth, this.isUpdateLocksOnDemand(), false, !depthIsSticky, this.getDebugLog());
            String target = "".equals(adminInfo.getTargetName()) ? null : adminInfo.getTargetName();
            long revNumber = this.getRevisionNumber(revision, repos, path);
            final SVNURL reposRoot = repos.getRepositoryRoot(true);
            wcAccess.setRepositoryRoot(path, reposRoot);
            final SVNRepository[] repos2 = new SVNRepository[1];
            ISVNFileFetcher fileFetcher = new ISVNFileFetcher(){

                @Override
                public long fetchFile(String path, long revision, OutputStream os, SVNProperties properties) throws SVNException {
                    SVNURL url = reposRoot.appendPath(SVNPathUtil.removeTail(path), false);
                    if (repos2[0] == null) {
                        repos2[0] = SVNUpdateClient16.this.createRepository(url, null, null, false);
                    } else {
                        repos2[0].setLocation(url, false);
                    }
                    return repos2[0].getFile(SVNPathUtil.tail(path), revision, properties, os);
                }
            };
            ISVNUpdateEditor editor = wcAccess.createUpdateEditor(adminInfo, null, allowUnversionedObstructions, depthIsSticky, depth, preservedExts, fileFetcher, this.isUpdateLocksOnDemand());
            ISVNEditor filterEditor = SVNAmbientDepthFilterEditor.wrap(editor, adminInfo, depthIsSticky);
            try {
                repos.update(revNumber, target, depth, sendCopyFrom, (ISVNReporterBaton)reporter, SVNCancellableEditor.newInstance(filterEditor, this, this.getDebugLog()));
            }
            finally {
                if (repos2[0] != null) {
                    repos2[0].closeSession();
                }
            }
            long targetRevision = editor.getTargetRevision();
            if (targetRevision >= 0L) {
                if (!(depth != SVNDepth.INFINITY && depth != SVNDepth.UNKNOWN || this.isIgnoreExternals())) {
                    this.handleExternals(wcAccess, adminInfo.getAnchor().getRoot(), adminInfo.getOldExternals(), adminInfo.getNewExternals(), adminInfo.getDepths(), url, reposRoot, depth, false, true);
                }
                this.dispatchEvent(SVNEventFactory.createSVNEvent(adminInfo.getTarget().getRoot(), SVNNodeKind.NONE, null, targetRevision, SVNEventAction.UPDATE_COMPLETED, null, null, null, reporter.getReportedFilesCount(), reporter.getTotalFilesCount()));
            }
            long l = targetRevision;
            return l;
        }
        finally {
            wcAccess.close();
            this.sleepForTimeStamp();
        }
    }

    public void setUpdateLocksOnDemand(boolean locksOnDemand) {
        this.myIsUpdateLocksOnDemand = locksOnDemand;
    }

    public boolean isUpdateLocksOnDemand() {
        return this.myIsUpdateLocksOnDemand;
    }

    public long doSwitch(File file, SVNURL url, SVNRevision revision, boolean recursive) throws SVNException {
        return this.doSwitch(file, url, SVNRevision.UNDEFINED, revision, SVNDepth.getInfinityOrFilesDepth(recursive), false, false);
    }

    public long doSwitch(File file, SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean recursive) throws SVNException {
        return this.doSwitch(file, url, pegRevision, revision, SVNDepth.getInfinityOrFilesDepth(recursive), false, false);
    }

    public long doSwitch(File file, SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean recursive, boolean force) throws SVNException {
        return this.doSwitch(file, url, pegRevision, revision, SVNDepth.getInfinityOrFilesDepth(recursive), force, false);
    }

    public long doSwitch(File path, SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SVNException {
        return this.doSwitchImpl(null, path, url, pegRevision, revision, depth, allowUnversionedObstructions, depthIsSticky);
    }

    public long doCheckout(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, boolean recursive) throws SVNException {
        return this.doCheckout(url, dstPath, pegRevision, revision, SVNDepth.fromRecurse(recursive), false);
    }

    public long doCheckout(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, boolean recursive, boolean force) throws SVNException {
        return this.doCheckout(url, dstPath, pegRevision, revision, SVNDepth.fromRecurse(recursive), force);
    }

    public long doCheckout(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions) throws SVNException {
        SVNErrorMessage err;
        if (dstPath == null) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "Checkout destination path can not be NULL");
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        SVNRevision sVNRevision = pegRevision = pegRevision == null ? SVNRevision.UNDEFINED : pegRevision;
        if (!revision.isValid() && pegRevision.isValid()) {
            revision = pegRevision;
        }
        if (!revision.isValid()) {
            revision = SVNRevision.HEAD;
        }
        SVNRepository repos = this.createRepository(url, null, null, pegRevision, revision, null);
        url = repos.getLocation();
        long revNumber = this.getRevisionNumber(revision, repos, null);
        SVNNodeKind targetNodeKind = repos.checkPath("", revNumber);
        if (targetNodeKind == SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "URL ''{0}'' refers to a file, not a directory", (Object)url);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (targetNodeKind == SVNNodeKind.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' doesn''t exist", (Object)url);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        String uuid = repos.getRepositoryUUID(true);
        SVNURL repositoryRoot = repos.getRepositoryRoot(true);
        long result = -1L;
        depth = depth == null ? SVNDepth.UNKNOWN : depth;
        SVNWCAccess wcAccess = this.createWCAccess();
        SVNFileType kind = SVNFileType.getType(dstPath);
        if (kind == SVNFileType.NONE) {
            depth = depth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : depth;
            SVNAdminAreaFactory.createVersionedDirectory(dstPath, url, repositoryRoot, uuid, revNumber, depth);
            result = this.update(dstPath, revision, depth, allowUnversionedObstructions, true, false);
        } else if (kind == SVNFileType.DIRECTORY) {
            int formatVersion = SVNAdminAreaFactory.checkWC(dstPath, true);
            if (formatVersion != 0) {
                SVNAdminArea adminArea = wcAccess.open(dstPath, false, 0);
                SVNEntry rootEntry = adminArea.getEntry(adminArea.getThisDirName(), false);
                wcAccess.closeAdminArea(dstPath);
                if (rootEntry.getSVNURL() != null && url.equals(rootEntry.getSVNURL())) {
                    result = this.update(dstPath, revision, depth, allowUnversionedObstructions, true, false);
                } else {
                    String message = "''{0}'' is already a working copy for a different URL";
                    if (rootEntry.isIncomplete()) {
                        message = message + "; perform update to complete it";
                    }
                    SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, message, (Object)dstPath);
                    SVNErrorManager.error(err3, SVNLogType.WC);
                }
            } else {
                depth = depth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : depth;
                SVNAdminAreaFactory.createVersionedDirectory(dstPath, url, repositoryRoot, uuid, revNumber, depth);
                result = this.update(dstPath, revision, depth, allowUnversionedObstructions, true, false);
            }
        } else {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.WC_NODE_KIND_CHANGE, "''{0}'' already exists and is not a directory", (Object)dstPath);
            SVNErrorManager.error(err4, SVNLogType.WC);
        }
        return result;
    }

    public long doExport(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, String eolStyle, boolean force, boolean recursive) throws SVNException {
        return this.doExport(url, dstPath, pegRevision, revision, eolStyle, force, SVNDepth.fromRecurse(recursive));
    }

    public long doExport(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, String eolStyle, boolean overwrite, SVNDepth depth) throws SVNException {
        long[] revNum = new long[]{-1L};
        SVNRepository repository = this.createRepository(url, null, null, pegRevision, revision, revNum);
        long exportedRevision = this.doRemoteExport(repository, revNum[0], dstPath, eolStyle, overwrite, depth);
        this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, exportedRevision, SVNEventAction.UPDATE_COMPLETED, null, null, null));
        return exportedRevision;
    }

    public long doExport(File srcPath, File dstPath, SVNRevision pegRevision, SVNRevision revision, String eolStyle, boolean force, boolean recursive) throws SVNException {
        return this.doExport(srcPath, dstPath, pegRevision, revision, eolStyle, force, SVNDepth.fromRecurse(recursive));
    }

    public long doExport(File srcPath, File dstPath, SVNRevision pegRevision, SVNRevision revision, String eolStyle, boolean overwrite, SVNDepth depth) throws SVNException {
        long exportedRevision = -1L;
        if (revision != SVNRevision.BASE && revision != SVNRevision.WORKING && revision != SVNRevision.COMMITTED && revision != SVNRevision.UNDEFINED) {
            SVNRepository repository = this.createRepository(null, srcPath, null, pegRevision, revision, null);
            long revisionNumber = this.getRevisionNumber(revision, repository, srcPath);
            exportedRevision = this.doRemoteExport(repository, revisionNumber, dstPath, eolStyle, overwrite, depth);
        } else {
            if (revision == SVNRevision.UNDEFINED) {
                revision = SVNRevision.WORKING;
            }
            this.copyVersionedDir(srcPath, dstPath, revision, eolStyle, overwrite, depth);
        }
        this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, exportedRevision, SVNEventAction.UPDATE_COMPLETED, null, null, null));
        return exportedRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRelocate(File dst, SVNURL oldURL, SVNURL newURL, boolean recursive) throws SVNException {
        try (SVNWCAccess wcAccess = this.createWCAccess();){
            SVNAdminArea adminArea = wcAccess.probeOpen(dst, true, recursive ? -1 : 0);
            String name = dst.equals(adminArea.getRoot()) ? adminArea.getThisDirName() : dst.getName();
            String from = oldURL.toString();
            String to = newURL.toString();
            if (from.endsWith("/")) {
                from = from.substring(0, from.length() - 1);
            }
            if (to.endsWith("/")) {
                to = to.substring(0, to.length() - 1);
            }
            this.doRelocate(adminArea, name, from, to, recursive, new SVNHashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCanonicalizeURLs(File dst, boolean omitDefaultPort, boolean recursive) throws SVNException {
        try (SVNWCAccess wcAccess = this.createWCAccess();){
            SVNAdminAreaInfo adminAreaInfo = wcAccess.openAnchor(dst, true, recursive ? -1 : 0);
            SVNAdminArea target = adminAreaInfo.getTarget();
            SVNEntry entry = wcAccess.getEntry(dst, false);
            String name = target.getThisDirName();
            if (entry != null && entry.isFile()) {
                name = entry.getName();
            }
            this.doCanonicalizeURLs(adminAreaInfo, target, name, omitDefaultPort, recursive);
            if (recursive && !this.isIgnoreExternals()) {
                for (String path : adminAreaInfo.getNewExternals().keySet()) {
                    String external = (String)adminAreaInfo.getNewExternals().get(path);
                    SVNExternal[] exts = SVNExternal.parseExternals(path, external);
                    File owner = new File(adminAreaInfo.getAnchor().getRoot(), path);
                    for (int i = 0; i < exts.length; ++i) {
                        File externalFile = new File(owner, exts[i].getPath());
                        try {
                            this.doCanonicalizeURLs(externalFile, omitDefaultPort, true);
                            continue;
                        }
                        catch (SVNCancelException e) {
                            throw e;
                        }
                        catch (SVNException e) {
                            this.getDebugLog().logFine(SVNLogType.WC, e);
                        }
                    }
                }
            }
        }
    }

    public void setExportExpandsKeywords(boolean expand) {
        this.myIsExportExpandsKeywords = expand;
    }

    public boolean isExportExpandsKeywords() {
        return this.myIsExportExpandsKeywords;
    }

    private void copyVersionedDir(File from, File to, SVNRevision revision, String eolStyle, boolean force, SVNDepth depth) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        SVNAdminArea adminArea = wcAccess.probeOpen(from, false, 0);
        SVNEntry entry = null;
        try {
            entry = wcAccess.getVersionedEntry(from, false);
        }
        catch (SVNException svne) {
            wcAccess.close();
            throw svne;
        }
        if (revision == SVNRevision.WORKING && entry.isScheduledForDeletion()) {
            return;
        }
        if (revision != SVNRevision.WORKING && entry.isScheduledForAddition()) {
            return;
        }
        if (entry.isDirectory()) {
            SVNVersionedProperties properties;
            String externalsValue;
            SVNErrorMessage err;
            boolean dirCreated = to.mkdirs();
            if (!to.exists() || to.isFile()) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directory ''{0}''", (Object)to);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (!dirCreated && to.isDirectory() && !force) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' already exists and will not be owerwritten unless forced", (Object)to);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (entry.isDirectory() && entry.isThisDir()) {
                Iterator ents = adminArea.entries(false);
                while (ents.hasNext()) {
                    File childTo;
                    SVNEntry childEntry = (SVNEntry)ents.next();
                    if (childEntry.isDirectory()) {
                        if (adminArea.getThisDirName().equals(childEntry.getName()) || depth != SVNDepth.INFINITY) continue;
                        childTo = new File(to, childEntry.getName());
                        File childFrom = new File(from, childEntry.getName());
                        this.copyVersionedDir(childFrom, childTo, revision, eolStyle, force, depth);
                        continue;
                    }
                    if (!childEntry.isFile()) continue;
                    childTo = new File(to, childEntry.getName());
                    this.copyVersionedFile(childTo, adminArea, childEntry.getName(), revision, eolStyle);
                }
            }
            if (!this.isIgnoreExternals() && depth == SVNDepth.INFINITY && entry.getDepth() == SVNDepth.INFINITY && (externalsValue = (properties = adminArea.getProperties(adminArea.getThisDirName())).getStringPropertyValue("svn:externals")) != null) {
                SVNExternal[] externals = SVNExternal.parseExternals(adminArea.getRoot().getAbsolutePath(), externalsValue);
                for (int i = 0; i < externals.length; ++i) {
                    SVNExternal info = externals[i];
                    File srcPath = new File(adminArea.getRoot(), info.getPath());
                    File dstPath = new File(to, info.getPath());
                    if (SVNPathUtil.getSegmentsCount(info.getPath()) > 1 && !dstPath.getParentFile().exists() && !dstPath.getParentFile().mkdirs()) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_DIRECTORY, "Could not create directory ''{0}''", (Object)dstPath.getParentFile()), SVNLogType.WC);
                    }
                    this.copyVersionedDir(srcPath, dstPath, revision, eolStyle, force, SVNDepth.INFINITY);
                }
            }
        } else if (entry.isFile()) {
            this.copyVersionedFile(to, adminArea, entry.getName(), revision, eolStyle);
        }
        wcAccess.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyVersionedFile(File dstPath, SVNAdminArea adminArea, String fileName, SVNRevision revision, String eol) throws SVNException {
        File srcFile;
        SVNFileType fileType;
        byte[] eols;
        SVNEntry entry = adminArea.getEntry(fileName, false);
        if (revision == SVNRevision.WORKING && entry.isScheduledForDeletion()) {
            return;
        }
        if (revision != SVNRevision.WORKING && entry.isScheduledForAddition()) {
            return;
        }
        boolean modified = false;
        SVNVersionedProperties props = null;
        if (revision != SVNRevision.WORKING) {
            props = adminArea.getBaseProperties(fileName);
        } else {
            props = adminArea.getProperties(fileName);
            modified = adminArea.hasTextModifications(fileName, false);
        }
        boolean special = props.getPropertyValue("svn:special") != null;
        boolean executable = props.getPropertyValue("svn:executable") != null;
        String keywords = props.getStringPropertyValue("svn:keywords");
        String charsetProp = props.getStringPropertyValue("svnkit:charset");
        String mimeType = props.getStringPropertyValue("svn:mime-type");
        String charset = SVNTranslator.getCharset(charsetProp, mimeType, adminArea.getFile(fileName).getPath(), this.getOptions());
        byte[] byArray = eols = eol != null ? SVNTranslator.getEOL(eol, this.getOptions()) : null;
        if (eols == null) {
            eol = props.getStringPropertyValue("svn:eol-style");
            eols = SVNTranslator.getEOL(eol, this.getOptions());
        }
        long timestamp = modified && !special ? SVNFileUtil.getFileLastModified(adminArea.getFile(fileName)) : SVNDate.parseDateAsMilliseconds(entry.getCommittedDate());
        Map<String, byte[]> keywordsMap = null;
        if (keywords != null) {
            String author;
            String rev = Long.toString(entry.getCommittedRevision());
            if (modified) {
                author = "(local)";
                rev = rev + "M";
            } else {
                author = entry.getAuthor();
            }
            keywordsMap = SVNTranslator.computeKeywords(keywords, entry.getURL(), author, entry.getCommittedDate(), rev, this.getOptions());
        }
        if ((fileType = SVNFileType.getType(srcFile = revision == SVNRevision.WORKING ? adminArea.getFile(fileName) : adminArea.getBaseFile(fileName, false))) == SVNFileType.SYMLINK && revision == SVNRevision.WORKING) {
            File tmpBaseFile = adminArea.getBaseFile(fileName, true);
            try {
                SVNTranslator.translate(srcFile, tmpBaseFile, charset, eols, keywordsMap, special, false);
                SVNTranslator.translate(tmpBaseFile, dstPath, charset, eols, keywordsMap, special, true);
            }
            finally {
                tmpBaseFile.delete();
            }
        } else {
            SVNTranslator.translate(srcFile, dstPath, charset, eols, keywordsMap, special, true);
        }
        if (executable) {
            SVNFileUtil.setExecutable(dstPath, true);
        }
        if (!special && timestamp > 0L) {
            SVNFileUtil.setLastModified(dstPath, timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doRemoteExport(SVNRepository repository, final long revNumber, File dstPath, String eolStyle, boolean force, SVNDepth depth) throws SVNException {
        SVNNodeKind dstKind = repository.checkPath("", revNumber);
        if (dstKind == SVNNodeKind.DIR) {
            SVNExportEditor editor = new SVNExportEditor(this, repository.getLocation().toString(), dstPath, force, eolStyle, this.isExportExpandsKeywords(), this.getOptions());
            repository.update(revNumber, null, depth, false, new ISVNReporterBaton(){

                @Override
                public void report(ISVNReporter reporter) throws SVNException {
                    reporter.setPath("", null, revNumber, SVNDepth.INFINITY, true);
                    reporter.finishReport();
                }
            }, SVNCancellableEditor.newInstance(editor, this, this.getDebugLog()));
            SVNFileType fileType = SVNFileType.getType(dstPath);
            if (fileType == SVNFileType.NONE) {
                editor.openRoot(revNumber);
            }
            if (!this.isIgnoreExternals() && depth == SVNDepth.INFINITY) {
                Map<String, String> externals = editor.getCollectedExternals();
                this.handleExternals(null, dstPath, Collections.EMPTY_MAP, externals, Collections.EMPTY_MAP, repository.getLocation(), repository.getRepositoryRoot(true), depth, true, true);
            }
        } else if (dstKind == SVNNodeKind.FILE) {
            String url = repository.getLocation().toString();
            if (dstPath.isDirectory()) {
                dstPath = new File(dstPath, SVNEncodingUtil.uriDecode(SVNPathUtil.tail(url)));
            }
            if (dstPath.exists()) {
                if (!force) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' already exists", (Object)dstPath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            } else {
                dstPath.getParentFile().mkdirs();
            }
            SVNProperties properties = new SVNProperties();
            OutputStream os = null;
            File tmpFile = SVNFileUtil.createUniqueFile(dstPath.getParentFile(), ".export", ".tmp", false);
            try {
                os = SVNFileUtil.openFileForWriting(tmpFile);
                try {
                    repository.getFile("", revNumber, properties, new SVNCancellableOutputStream(os, this));
                }
                finally {
                    SVNFileUtil.closeFile(os);
                }
                if (force && dstPath.exists()) {
                    SVNFileUtil.deleteAll(dstPath, this);
                }
                if (!this.isExportExpandsKeywords()) {
                    properties.put("svn:mime-type", "application/octet-stream");
                }
                String mimeType = properties.getStringValue("svn:mime-type");
                boolean binary = SVNProperty.isBinaryMimeType(mimeType);
                String charset = SVNTranslator.getCharset(properties.getStringValue("svnkit:charset"), mimeType, url, this.getOptions());
                Map<String, byte[]> keywords = SVNTranslator.computeKeywords(properties.getStringValue("svn:keywords"), url, properties.getStringValue("svn:entry:last-author"), properties.getStringValue("svn:entry:committed-date"), properties.getStringValue("svn:entry:committed-rev"), this.getOptions());
                byte[] eols = null;
                if ("native".equals(properties.getStringValue("svn:eol-style"))) {
                    eols = SVNTranslator.getEOL(eolStyle != null ? eolStyle : properties.getStringValue("svn:eol-style"), this.getOptions());
                } else if (properties.containsName("svn:eol-style")) {
                    eols = SVNTranslator.getEOL(properties.getStringValue("svn:eol-style"), this.getOptions());
                }
                if (binary) {
                    charset = null;
                    eols = null;
                    keywords = null;
                }
                SVNTranslator.translate(tmpFile, dstPath, charset, eols, keywords, properties.getStringValue("svn:special") != null, true);
            }
            finally {
                SVNFileUtil.deleteFile(tmpFile);
            }
            if (properties.getStringValue("svn:executable") != null) {
                SVNFileUtil.setExecutable(dstPath, true);
            }
            this.dispatchEvent(SVNEventFactory.createSVNEvent(dstPath, SVNNodeKind.FILE, null, -1L, SVNEventAction.UPDATE_ADD, null, null, null));
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' doesn't exist", (Object)repository.getLocation());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return revNumber;
    }

    private void doCanonicalizeURLs(SVNAdminAreaInfo adminAreaInfo, SVNAdminArea adminArea, String name, boolean omitDefaultPort, boolean recursive) throws SVNException {
        SVNPropertyValue externalsValue;
        boolean save = false;
        this.checkCancelled();
        if (!adminArea.getThisDirName().equals(name)) {
            SVNEntry entry = adminArea.getEntry(name, true);
            save = SVNUpdateClient16.canonicalizeEntry(entry, omitDefaultPort);
            adminArea.getWCProperties(name).setPropertyValue("svn:wc:ra_dav:version-url", null);
            if (save) {
                adminArea.saveEntries(false);
            }
            return;
        }
        if (!this.isIgnoreExternals() && (externalsValue = adminArea.getProperties(adminArea.getThisDirName()).getPropertyValue("svn:externals")) != null) {
            String ownerPath = adminArea.getRelativePath(adminAreaInfo.getAnchor());
            String externals = externalsValue == null ? null : externalsValue.getString();
            adminAreaInfo.addExternal(ownerPath, externals, externals);
            if (externalsValue != null) {
                externalsValue = SVNPropertyValue.create(SVNUpdateClient16.canonicalizeExtenrals(externals, omitDefaultPort));
                adminArea.getProperties(adminArea.getThisDirName()).setPropertyValue("svn:externals", externalsValue);
            }
        }
        SVNEntry rootEntry = adminArea.getEntry(adminArea.getThisDirName(), true);
        save = SVNUpdateClient16.canonicalizeEntry(rootEntry, omitDefaultPort);
        adminArea.getWCProperties(adminArea.getThisDirName()).setPropertyValue("svn:wc:ra_dav:version-url", null);
        Iterator ents = adminArea.entries(true);
        while (ents.hasNext()) {
            SVNAdminArea childArea;
            SVNEntry entry = (SVNEntry)ents.next();
            if (adminArea.getThisDirName().equals(entry.getName())) continue;
            this.checkCancelled();
            if (recursive && entry.isDirectory() && (entry.isScheduledForAddition() || !entry.isDeleted()) && !entry.isAbsent() && (childArea = adminArea.getWCAccess().retrieve(adminArea.getFile(entry.getName()))) != null) {
                this.doCanonicalizeURLs(adminAreaInfo, childArea, "", omitDefaultPort, recursive);
            }
            save |= SVNUpdateClient16.canonicalizeEntry(entry, omitDefaultPort);
            SVNVersionedProperties properties = adminArea.getWCProperties(entry.getName());
            if (properties == null) continue;
            properties.setPropertyValue("svn:wc:ra_dav:version-url", null);
        }
        if (save) {
            adminArea.saveEntries(true);
        }
    }

    public static String canonicalizeExtenrals(String externals, boolean omitDefaultPort) throws SVNException {
        if (externals == null) {
            return null;
        }
        StringBuffer canonicalized = new StringBuffer();
        StringTokenizer lines = new StringTokenizer(externals, "\r\n", true);
        while (lines.hasMoreTokens()) {
            SVNURL canonicalURL;
            String line = lines.nextToken();
            if (line.trim().length() == 0 || line.trim().startsWith("#") || line.indexOf(13) >= 0 || line.indexOf(10) >= 0) {
                canonicalized.append(line);
                continue;
            }
            String[] tokens = line.split("[ \t]");
            int index = tokens.length - 1;
            SVNURL url = null;
            if (index >= 1) {
                try {
                    url = SVNURL.parseURIEncoded(tokens[index]);
                }
                catch (SVNException e) {
                    url = null;
                }
            }
            if ((canonicalURL = SVNUpdateClient16.canonicalizeURL(url, omitDefaultPort)) == null) {
                canonicalized.append(line);
                continue;
            }
            canonicalized.append(tokens[0]);
            canonicalized.append(' ');
            if (index == 2) {
                canonicalized.append(tokens[1]);
                canonicalized.append(' ');
            }
            canonicalized.append(canonicalURL.toString());
        }
        return canonicalized.toString();
    }

    private static boolean canonicalizeEntry(SVNEntry entry, boolean omitDefaultPort) throws SVNException {
        SVNURL copyFrom;
        SVNURL url;
        boolean updated = false;
        SVNURL root = SVNUpdateClient16.canonicalizeURL(entry.getRepositoryRootURL(), omitDefaultPort);
        if (root != null) {
            updated |= entry.setRepositoryRootURL(root);
        }
        if ((url = SVNUpdateClient16.canonicalizeURL(entry.getSVNURL(), omitDefaultPort)) != null) {
            updated |= entry.setURL(url.toString());
        }
        if ((copyFrom = SVNUpdateClient16.canonicalizeURL(entry.getCopyFromSVNURL(), omitDefaultPort)) != null) {
            updated |= entry.setCopyFromURL(copyFrom.toString());
        }
        return updated;
    }

    public static SVNURL canonicalizeURL(SVNURL url, boolean omitDefaultPort) throws SVNException {
        if (url == null || url.getPort() <= 0) {
            return null;
        }
        int defaultPort = SVNURL.getDefaultPortNumber(url.getProtocol());
        if (defaultPort <= 0) {
            return null;
        }
        if (omitDefaultPort) {
            if (url.hasPort() && url.getPort() == defaultPort) {
                return SVNURL.create(url.getProtocol(), url.getUserInfo(), url.getHost(), -1, url.getPath(), false);
            }
        } else if (!url.hasPort()) {
            return SVNURL.create(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), false);
        }
        return null;
    }

    private void handleExternals(SVNWCAccess wcAccess, File root, Map oldExternals, Map newExternals, Map depths, SVNURL fromURL, SVNURL rootURL, SVNDepth requestedDepth, boolean isExport, boolean updateUnchanged) throws SVNException {
        SVNHashSet diff = new SVNHashSet();
        if (oldExternals != null) {
            diff.addAll(oldExternals.keySet());
        }
        if (newExternals != null) {
            diff.addAll(newExternals.keySet());
        }
        for (String diffPath : diff) {
            int i;
            SVNDepth ambientDepth;
            SVNDepth sVNDepth = ambientDepth = depths == Collections.EMPTY_MAP ? SVNDepth.INFINITY : (SVNDepth)depths.get(diffPath);
            if (ambientDepth == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Traversal of ''{0}'' found no ambient depth", (Object)diffPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (!ambientDepth.isRecursive() || !requestedDepth.isRecursive()) continue;
            String oldValue = (String)oldExternals.get(diffPath);
            String newValue = (String)newExternals.get(diffPath);
            SVNExternal[] previous = oldValue != null ? SVNExternal.parseExternals(diffPath, oldValue) : null;
            SVNExternal[] current = newValue != null ? SVNExternal.parseExternals(diffPath, newValue) : null;
            LinkedHashMap<String, SVNExternal> oldParsedExternals = new LinkedHashMap<String, SVNExternal>();
            LinkedHashMap<String, SVNExternal> newParsedExternals = new LinkedHashMap<String, SVNExternal>();
            for (i = 0; current != null && i < current.length; ++i) {
                newParsedExternals.put(current[i].getPath(), current[i]);
            }
            for (i = 0; previous != null && i < previous.length; ++i) {
                oldParsedExternals.put(previous[i].getPath(), previous[i]);
            }
            ExternalDiff externalDiff = new ExternalDiff();
            externalDiff.isExport = isExport;
            externalDiff.isUpdateUnchanged = updateUnchanged;
            externalDiff.rootURL = rootURL;
            for (String path : oldParsedExternals.keySet()) {
                externalDiff.oldExternal = (SVNExternal)oldParsedExternals.get(path);
                externalDiff.newExternal = (SVNExternal)newParsedExternals.get(path);
                externalDiff.owner = new File(root, diffPath);
                if (!isExport) {
                    externalDiff.ownerURL = this.getOwnerURL(externalDiff.owner);
                }
                if (externalDiff.ownerURL == null) {
                    externalDiff.ownerURL = fromURL.appendPath(diffPath, false);
                }
                this.handleExternalItemChange(wcAccess, externalDiff.oldExternal.getPath(), externalDiff);
            }
            for (String path : newParsedExternals.keySet()) {
                if (oldParsedExternals.containsKey(path)) continue;
                externalDiff.oldExternal = null;
                externalDiff.newExternal = (SVNExternal)newParsedExternals.get(path);
                externalDiff.owner = new File(root, diffPath);
                if (!isExport) {
                    externalDiff.ownerURL = this.getOwnerURL(externalDiff.owner);
                }
                if (externalDiff.ownerURL == null) {
                    externalDiff.ownerURL = fromURL.appendPath(diffPath, false);
                }
                this.handleExternalItemChange(wcAccess, externalDiff.newExternal.getPath(), externalDiff);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNURL getOwnerURL(File root) {
        if (root != null && SVNFileType.getType(root) == SVNFileType.DIRECTORY) {
            SVNWCAccess access = this.createWCAccess();
            try {
                access.open(root, false, 0);
                SVNEntry entry = access.getVersionedEntry(root, false);
                if (entry != null) {
                    SVNURL sVNURL = entry.getSVNURL();
                    return sVNURL;
                }
            }
            catch (SVNException e) {
                e.printStackTrace();
            }
            finally {
                if (access != null) {
                    try {
                        access.close();
                    }
                    catch (SVNException sVNException) {}
                }
            }
        }
        return null;
    }

    private void handleExternalItemChange(SVNWCAccess access, String targetDir, ExternalDiff externalDiff) throws SVNException {
        try {
            this.handleExternalChange(access, targetDir, externalDiff);
        }
        catch (SVNException svne) {
            File target = new File(externalDiff.owner, targetDir);
            SVNEvent event = SVNEventFactory.createSVNEvent(target, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.FAILED_EXTERNAL, SVNEventAction.UPDATE_EXTERNAL, svne.getErrorMessage(), null);
            this.dispatchEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleExternalChange(SVNWCAccess access, String targetDir, ExternalDiff externalDiff) throws SVNException {
        File target = new File(externalDiff.owner, targetDir);
        SVNURL oldURL = null;
        SVNURL newURL = null;
        String externalDefinition = null;
        if (externalDiff.oldExternal != null && !externalDiff.isExport) {
            oldURL = externalDiff.oldExternal.resolveURL(externalDiff.rootURL, externalDiff.ownerURL);
            externalDefinition = externalDiff.oldExternal.getRawValue();
        }
        SVNRevision externalRevision = SVNRevision.UNDEFINED;
        SVNRevision externalPegRevision = SVNRevision.UNDEFINED;
        if (externalDiff.newExternal != null) {
            newURL = externalDiff.newExternal.resolveURL(externalDiff.rootURL, externalDiff.ownerURL);
            externalRevision = externalDiff.newExternal.getRevision();
            externalPegRevision = externalDiff.newExternal.getPegRevision();
            externalDefinition = externalDiff.newExternal.getRawValue();
        }
        if (oldURL == null && newURL == null) {
            return;
        }
        SVNRevision[] revs = this.getExternalsHandler().handleExternal(target, newURL, externalRevision, externalPegRevision, externalDefinition, SVNRevision.UNDEFINED);
        if (revs == null) {
            SVNEvent event = SVNEventFactory.createSVNEvent(target, SVNNodeKind.DIR, null, -1L, SVNEventAction.SKIP, SVNEventAction.UPDATE_EXTERNAL, null, null);
            this.dispatchEvent(event);
            return;
        }
        externalRevision = revs.length > 0 && revs[0] != null ? revs[0] : externalRevision;
        externalPegRevision = revs.length > 1 && revs[1] != null ? revs[1] : externalPegRevision;
        SVNRepository repository = null;
        SVNNodeKind kind = null;
        SVNURL reposRootURL = null;
        if (newURL != null) {
            SVNErrorMessage err;
            long[] rev = new long[]{-1L};
            repository = this.createRepository(newURL, null, null, externalPegRevision, externalRevision, rev);
            reposRootURL = repository.getRepositoryRoot(true);
            kind = repository.checkPath("", rev[0]);
            if (kind == SVNNodeKind.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' at revision {1} doesn''t exist", repository.getLocation(), String.valueOf(rev[0]));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (kind != SVNNodeKind.DIR && kind != SVNNodeKind.FILE) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' at revision {1} is not a file or a directory", repository.getLocation(), String.valueOf(rev[0]));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        try {
            this.setEventPathPrefix("path");
            if (oldURL == null) {
                if (kind == SVNNodeKind.DIR) {
                    target.mkdirs();
                    this.dispatchEvent(SVNEventFactory.createSVNEvent(target, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPDATE_EXTERNAL, null, null, null));
                    if (externalDiff.isExport) {
                        this.doExport(newURL, target, externalPegRevision, externalRevision, null, true, SVNDepth.INFINITY);
                        return;
                    }
                    this.doCheckout(newURL, target, externalPegRevision, externalRevision, SVNDepth.INFINITY, false);
                    return;
                }
                if (kind != SVNNodeKind.FILE) return;
                this.dispatchEvent(SVNEventFactory.createSVNEvent(target, SVNNodeKind.FILE, null, -1L, SVNEventAction.UPDATE_EXTERNAL, null, null, null));
                if (externalDiff.isExport) {
                    boolean ignoreExternals = this.isIgnoreExternals();
                    this.setIgnoreExternals(true);
                    this.doExport(newURL, target, externalPegRevision, externalRevision, null, false, SVNDepth.INFINITY);
                    this.setIgnoreExternals(ignoreExternals);
                    return;
                }
                this.switchFileExternal(access, target, newURL, externalPegRevision, externalRevision, reposRootURL);
                return;
            }
            if (newURL == null) {
                SVNWCAccess wcAccess = this.createWCAccess();
                SVNAdminArea area = wcAccess.open(target, true, -1);
                SVNException error = null;
                try {
                    area.removeFromRevisionControl(area.getThisDirName(), true, false);
                }
                catch (SVNException svne) {
                    error = svne;
                }
                if (error == null || error.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                    try {
                        wcAccess.close();
                    }
                    catch (SVNException svne) {
                        error = error == null ? svne : error;
                    }
                }
                if (error == null) return;
                if (error.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) return;
                throw error;
            }
            if (!externalDiff.isUpdateUnchanged) {
                if (externalDiff.compareExternals(oldURL, newURL)) return;
            }
            if (kind == SVNNodeKind.DIR) {
                File[] children;
                SVNFileType fileType = SVNFileType.getType(target);
                boolean empty = false;
                if (fileType == SVNFileType.DIRECTORY && (children = target.listFiles()) != null && children.length == 0) {
                    empty = true;
                }
                if (fileType == SVNFileType.DIRECTORY && !empty) {
                    this.dispatchEvent(SVNEventFactory.createSVNEvent(target, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPDATE_EXTERNAL, null, null, null));
                    SVNWCAccess wcAccess = this.createWCAccess();
                    SVNAdminArea area = wcAccess.open(target, true, 0);
                    SVNEntry entry = area.getEntry(area.getThisDirName(), false);
                    wcAccess.close();
                    String url = entry.getURL();
                    if (entry != null && entry.getURL() != null) {
                        if (newURL.toString().equals(url)) {
                            this.doUpdate(target, externalRevision, SVNDepth.UNKNOWN, true, false);
                            return;
                        }
                        if (entry.getRepositoryRoot() != null) {
                            if (!SVNPathUtil.isAncestor(entry.getRepositoryRoot(), newURL.toString())) {
                                SVNRepository repos = this.createRepository(newURL, null, null, true);
                                SVNURL reposRoot = repos.getRepositoryRoot(true);
                                try {
                                    this.doRelocate(target, entry.getSVNURL(), reposRoot, true);
                                }
                                catch (SVNException svne) {
                                    if (svne.getErrorMessage().getErrorCode() != SVNErrorCode.WC_INVALID_RELOCATION) {
                                        if (svne.getErrorMessage().getErrorCode() != SVNErrorCode.CLIENT_INVALID_RELOCATION) throw svne;
                                    }
                                    this.deleteExternal(target);
                                    target.mkdirs();
                                    this.doCheckout(newURL, target, externalPegRevision, externalRevision, SVNDepth.INFINITY, false);
                                    this.setEventPathPrefix(null);
                                    return;
                                }
                            }
                            this.doSwitch(target, newURL, externalPegRevision, externalRevision, SVNDepth.INFINITY, false, true);
                            return;
                        }
                    }
                    this.deleteExternal(target);
                    target.mkdirs();
                    this.dispatchEvent(SVNEventFactory.createSVNEvent(target, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPDATE_EXTERNAL, null, null, null));
                    this.doCheckout(newURL, target, externalPegRevision, externalRevision, SVNDepth.INFINITY, false);
                    return;
                }
                if (fileType != SVNFileType.DIRECTORY) {
                    target.mkdirs();
                }
                this.dispatchEvent(SVNEventFactory.createSVNEvent(target, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPDATE_EXTERNAL, null, null, null));
                this.doCheckout(newURL, target, externalPegRevision, externalRevision, SVNDepth.INFINITY, true);
                return;
            }
            this.dispatchEvent(SVNEventFactory.createSVNEvent(target, SVNNodeKind.FILE, null, -1L, SVNEventAction.UPDATE_EXTERNAL, null, null, null));
            this.switchFileExternal(access, target, newURL, externalPegRevision, externalRevision, reposRootURL);
            return;
        }
        catch (SVNCancelException cancel) {
            throw cancel;
        }
        catch (SVNException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, e);
            SVNEvent event = SVNEventFactory.createSVNEvent(target, SVNNodeKind.DIR, null, -1L, SVNEventAction.SKIP, SVNEventAction.UPDATE_EXTERNAL, e.getErrorMessage(), null);
            this.dispatchEvent(event);
            return;
        }
        finally {
            this.setEventPathPrefix(null);
        }
    }

    private void switchFileExternal(SVNWCAccess wcAccess, File path, SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNURL reposRootURL) throws SVNException {
        String target = SVNWCManager.getActualTarget(path);
        File anchor = "".equals(target) ? path : path.getParentFile();
        boolean closeTarget = false;
        boolean revertFile = false;
        boolean removeFromRevisionControl = false;
        boolean unlinkFile = false;
        boolean cleanUp = false;
        boolean ignoreExternals = this.isIgnoreExternals();
        SVNAdminArea targetArea = null;
        try {
            SVNErrorMessage err;
            try {
                targetArea = wcAccess.retrieve(anchor);
            }
            catch (SVNException svne) {
                err = svne.getErrorMessage();
                if (err.getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    SVNWCAccess targetAccess = SVNWCAccess.newInstance(null);
                    targetArea = targetAccess.open(anchor, true, 1);
                    closeTarget = true;
                    SVNURL dstWCReposRootURL = this.getReposRoot(anchor, null, SVNRevision.BASE, targetArea, targetAccess);
                    if (!reposRootURL.equals(dstWCReposRootURL)) {
                        SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.RA_REPOS_ROOT_URL_MISMATCH, "Cannot insert a file external from ''{0}'' into a working copy from a different repository rooted at ''{1}''", url, dstWCReposRootURL);
                        SVNErrorManager.error(err1, SVNLogType.WC);
                    }
                }
                throw svne;
            }
            if (targetArea.getFormatVersion() < 10) {
                this.dispatchEvent(SVNEventFactory.createSVNEvent(path, SVNNodeKind.FILE, null, -1L, SVNEventAction.SKIP, SVNEventAction.UPDATE_EXTERNAL, null, null));
                return;
            }
            SVNEntry entry = targetArea.getEntry(target, false);
            if (entry != null) {
                if (entry.getExternalFilePath() == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.CLIENT_FILE_EXTERNAL_OVERWRITE_VERSIONED, "The file external from ''{0}'' cannot overwrite the existing versioned item at ''{1}''", url, path);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            } else {
                targetArea.getVersionedEntry(targetArea.getThisDirName(), false);
                boolean hasPropConflicts = targetArea.hasPropConflict(targetArea.getThisDirName());
                boolean hasTreeConflicts = targetArea.hasTreeConflict(targetArea.getThisDirName());
                if (hasPropConflicts || hasTreeConflicts) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "The file external from ''{0}'' cannot be written to ''{1}'' while ''{2}'' remains in conflict", url, path, anchor);
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
                if (!path.exists()) {
                    SVNFileUtil.createEmptyFile(path);
                    unlinkFile = true;
                }
                ISVNEventHandler eventHandler = targetArea.getWCAccess().getEventHandler();
                try {
                    targetArea.getWCAccess().setEventHandler(null);
                    SVNWCManager.add(path, targetArea, null, -1L, SVNDepth.INFINITY);
                }
                catch (SVNException svne) {
                    cleanUp = true;
                    throw svne;
                }
                finally {
                    if (eventHandler != null) {
                        targetArea.getWCAccess().setEventHandler(eventHandler);
                    }
                }
                revertFile = true;
                try {
                    targetArea.setFileExternalLocation(target, url, pegRevision, revision, reposRootURL);
                }
                catch (SVNException svne) {
                    cleanUp = true;
                    throw svne;
                }
            }
            this.setIgnoreExternals(true);
            try {
                this.doSwitchImpl(targetArea.getWCAccess(), path, url, pegRevision, revision, SVNDepth.EMPTY, false, false);
            }
            catch (SVNException svne) {
                cleanUp = true;
                throw svne;
            }
            if (unlinkFile) {
                revertFile = false;
                removeFromRevisionControl = true;
            }
        }
        catch (SVNException svne) {
            if (cleanUp) {
                if (revertFile) {
                    SVNWCClient16 wcClient = new SVNWCClient16(this.getRepositoryPool(), this.getOptions());
                    try {
                        wcClient.doRevert(new File[]{path}, SVNDepth.EMPTY, null);
                    }
                    catch (SVNException svne2) {
                        // empty catch block
                    }
                }
                if (removeFromRevisionControl) {
                    try {
                        targetArea.removeFromRevisionControl(target, true, false);
                    }
                    catch (SVNException svne2) {
                        // empty catch block
                    }
                }
                if (unlinkFile) {
                    try {
                        SVNFileUtil.deleteFile(path);
                    }
                    catch (SVNException svne2) {
                        // empty catch block
                    }
                }
            }
            throw svne;
        }
        finally {
            this.setIgnoreExternals(ignoreExternals);
            if (closeTarget) {
                targetArea.getWCAccess().close();
            }
        }
    }

    private void deleteExternal(File external) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        SVNAdminArea adminArea = wcAccess.open(external, true, -1);
        SVNException error = null;
        try {
            adminArea.removeFromRevisionControl(adminArea.getThisDirName(), true, false);
        }
        catch (SVNException svne) {
            this.getDebugLog().logFine(SVNLogType.WC, svne);
            error = svne;
        }
        if (error == null || error.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            wcAccess.close();
        }
        if (error != null && error.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            external.getParentFile().mkdirs();
            File newLocation = SVNFileUtil.createUniqueFile(external.getParentFile(), external.getName(), ".OLD", false);
            SVNFileUtil.rename(external, newLocation);
        } else if (error != null) {
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map validateRelocateTargetURL(SVNURL targetURL, String expectedUUID, Map validatedURLs, boolean isRoot) throws SVNException {
        if (validatedURLs == null) {
            return null;
        }
        for (SVNURL validatedURL : validatedURLs.keySet()) {
            if (!targetURL.toString().startsWith(validatedURL.toString())) continue;
            if (isRoot && !targetURL.equals(validatedURL)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "''{0}'' is not the root of the repository", (Object)targetURL);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            String validatedUUID = (String)validatedURLs.get(validatedURL);
            if (expectedUUID != null && !expectedUUID.equals(validatedUUID)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "The repository at ''{0}'' has uuid ''{1}'', but the WC has ''{2}''", validatedURL, validatedUUID, expectedUUID);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            return validatedURLs;
        }
        SVNRepository repos = this.createRepository(targetURL, null, null, false);
        try {
            SVNURL actualRoot = repos.getRepositoryRoot(true);
            if (isRoot && !targetURL.equals(actualRoot)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "''{0}'' is not the root of the repository", (Object)targetURL);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            String actualUUID = repos.getRepositoryUUID(true);
            if (expectedUUID != null && !expectedUUID.equals(actualUUID)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "The repository at ''{0}'' has uuid ''{1}'', but the WC has ''{2}''", targetURL, actualUUID, expectedUUID);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            validatedURLs.put(targetURL, actualUUID);
        }
        finally {
            repos.closeSession();
        }
        return validatedURLs;
    }

    private Map relocateEntry(SVNEntry entry, String from, String to, Map validatedURLs) throws SVNException {
        if (entry.getRepositoryRoot() != null) {
            String repos = entry.getRepositoryRoot();
            if (from.length() > repos.length()) {
                String fromPath = from.substring(repos.length());
                if (!to.endsWith(fromPath)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_RELOCATION, "Relocate can only change the repository part of an URL");
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                from = repos;
                to = to.substring(0, to.length() - fromPath.length());
            }
            if (repos.startsWith(from)) {
                entry.setRepositoryRoot(to + repos.substring(from.length()));
                validatedURLs = this.validateRelocateTargetURL(entry.getRepositoryRootURL(), entry.getUUID(), validatedURLs, true);
            }
        }
        if (entry.getURL() != null && entry.getURL().startsWith(from)) {
            entry.setURL(to + entry.getURL().substring(from.length()));
            if (entry.getUUID() != null && validatedURLs != null) {
                validatedURLs = this.validateRelocateTargetURL(entry.getSVNURL(), entry.getUUID(), validatedURLs, false);
            }
        }
        if (entry.getCopyFromURL() != null && entry.getCopyFromURL().startsWith(from)) {
            entry.setCopyFromURL(to + entry.getCopyFromURL().substring(from.length()));
            if (entry.getUUID() != null && validatedURLs != null) {
                validatedURLs = this.validateRelocateTargetURL(entry.getCopyFromSVNURL(), entry.getUUID(), validatedURLs, false);
            }
        }
        return validatedURLs;
    }

    private Map doRelocate(SVNAdminArea adminArea, String name, String from, String to, boolean recursive, Map validatedURLs) throws SVNException {
        SVNEntry entry = adminArea.getEntry(name, true);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (entry.isFile()) {
            this.relocateEntry(entry, from, to, validatedURLs);
            SVNPropertiesManager.deleteWCProperties(adminArea, name, false);
            adminArea.saveEntries(false);
            return validatedURLs;
        }
        validatedURLs = this.relocateEntry(entry, from, to, validatedURLs);
        SVNWCAccess wcAccess = adminArea.getWCAccess();
        Iterator entries = adminArea.entries(true);
        while (entries.hasNext()) {
            SVNEntry childEntry = (SVNEntry)entries.next();
            if (adminArea.getThisDirName().equals(childEntry.getName())) continue;
            if (recursive && childEntry.isDirectory() && (childEntry.isScheduledForAddition() || !childEntry.isDeleted()) && !childEntry.isAbsent() && childEntry.getDepth() != SVNDepth.EXCLUDE) {
                File childDir = adminArea.getFile(childEntry.getName());
                if (wcAccess.isMissing(childDir)) continue;
                SVNAdminArea childArea = wcAccess.retrieve(childDir);
                validatedURLs = this.doRelocate(childArea, childArea.getThisDirName(), from, to, recursive, validatedURLs);
            }
            validatedURLs = this.relocateEntry(childEntry, from, to, validatedURLs);
            SVNPropertiesManager.deleteWCProperties(adminArea, childEntry.getName(), false);
        }
        SVNPropertiesManager.deleteWCProperties(adminArea, "", false);
        adminArea.saveEntries(false);
        return validatedURLs;
    }

    private static class ExternalDiff {
        public SVNExternal oldExternal;
        public SVNExternal newExternal;
        public File owner;
        public SVNURL ownerURL;
        public SVNURL rootURL;
        public boolean isExport;
        public boolean isUpdateUnchanged;

        private ExternalDiff() {
        }

        public boolean compareExternals(SVNURL oldURL, SVNURL newURL) {
            return oldURL.equals(newURL) && this.oldExternal.getRevision().equals(this.newExternal.getRevision()) && this.oldExternal.getPegRevision().equals(this.newExternal.getPegRevision());
        }
    }
}

