/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ConfigIllegalValueException;

public enum TagOpt {
    AUTO_FOLLOW(""),
    NO_TAGS("--no-tags"),
    FETCH_TAGS("--tags");

    private final String option;

    private TagOpt(String o) {
        this.option = o;
    }

    public String option() {
        return this.option;
    }

    public static TagOpt fromOption(String o) throws ConfigIllegalValueException {
        if (o == null || o.length() == 0) {
            return AUTO_FOLLOW;
        }
        for (TagOpt tagopt : TagOpt.values()) {
            if (!tagopt.option().equals(o)) continue;
            return tagopt;
        }
        throw new ConfigIllegalValueException(MessageFormat.format(JGitText.get().invalidTagOption, o));
    }
}

