/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.RepositorySystemSession;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    public static Object getObject(Map<?, ?> properties, Object defaultValue, String ... keys2) {
        for (String key2 : keys2) {
            Object value = properties.get(key2);
            if (value == null) continue;
            return value;
        }
        return defaultValue;
    }

    public static Object getObject(RepositorySystemSession session2, Object defaultValue, String ... keys2) {
        return ConfigUtils.getObject(session2.getConfigProperties(), defaultValue, keys2);
    }

    public static String getString(Map<?, ?> properties, String defaultValue, String ... keys2) {
        for (String key2 : keys2) {
            Object value = properties.get(key2);
            if (!(value instanceof String)) continue;
            return (String)value;
        }
        return defaultValue;
    }

    public static String getString(RepositorySystemSession session2, String defaultValue, String ... keys2) {
        return ConfigUtils.getString(session2.getConfigProperties(), defaultValue, keys2);
    }

    public static int getInteger(Map<?, ?> properties, int defaultValue, String ... keys2) {
        for (String key2 : keys2) {
            Object value = properties.get(key2);
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            try {
                return Integer.parseInt((String)value);
            }
            catch (Exception exception) {
            }
        }
        return defaultValue;
    }

    public static int getInteger(RepositorySystemSession session2, int defaultValue, String ... keys2) {
        return ConfigUtils.getInteger(session2.getConfigProperties(), defaultValue, keys2);
    }

    public static long getLong(Map<?, ?> properties, long defaultValue, String ... keys2) {
        for (String key2 : keys2) {
            Object value = properties.get(key2);
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            try {
                return Long.parseLong((String)value);
            }
            catch (Exception exception) {
            }
        }
        return defaultValue;
    }

    public static long getLong(RepositorySystemSession session2, long defaultValue, String ... keys2) {
        return ConfigUtils.getLong(session2.getConfigProperties(), defaultValue, keys2);
    }

    public static float getFloat(Map<?, ?> properties, float defaultValue, String ... keys2) {
        for (String key2 : keys2) {
            Object value = properties.get(key2);
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            try {
                return Float.parseFloat((String)value);
            }
            catch (Exception exception) {
            }
        }
        return defaultValue;
    }

    public static float getFloat(RepositorySystemSession session2, float defaultValue, String ... keys2) {
        return ConfigUtils.getFloat(session2.getConfigProperties(), defaultValue, keys2);
    }

    public static boolean getBoolean(Map<?, ?> properties, boolean defaultValue, String ... keys2) {
        for (String key2 : keys2) {
            Object value = properties.get(key2);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (!(value instanceof String)) continue;
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    public static boolean getBoolean(RepositorySystemSession session2, boolean defaultValue, String ... keys2) {
        return ConfigUtils.getBoolean(session2.getConfigProperties(), defaultValue, keys2);
    }

    public static List<?> getList(Map<?, ?> properties, List<?> defaultValue, String ... keys2) {
        for (String key2 : keys2) {
            Object value = properties.get(key2);
            if (value instanceof List) {
                return (List)value;
            }
            if (!(value instanceof Collection)) continue;
            return Collections.unmodifiableList(new ArrayList((Collection)value));
        }
        return defaultValue;
    }

    public static List<?> getList(RepositorySystemSession session2, List<?> defaultValue, String ... keys2) {
        return ConfigUtils.getList(session2.getConfigProperties(), defaultValue, keys2);
    }

    public static Map<?, ?> getMap(Map<?, ?> properties, Map<?, ?> defaultValue, String ... keys2) {
        for (String key2 : keys2) {
            Object value = properties.get(key2);
            if (!(value instanceof Map)) continue;
            return (Map)value;
        }
        return defaultValue;
    }

    public static Map<?, ?> getMap(RepositorySystemSession session2, Map<?, ?> defaultValue, String ... keys2) {
        return ConfigUtils.getMap(session2.getConfigProperties(), defaultValue, keys2);
    }
}

