/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;

class CachingArtifactTypeRegistry
implements ArtifactTypeRegistry {
    private final ArtifactTypeRegistry delegate;
    private final Map<String, ArtifactType> types;

    public static ArtifactTypeRegistry newInstance(RepositorySystemSession session2) {
        return CachingArtifactTypeRegistry.newInstance(session2.getArtifactTypeRegistry());
    }

    public static ArtifactTypeRegistry newInstance(ArtifactTypeRegistry delegate) {
        return delegate != null ? new CachingArtifactTypeRegistry(delegate) : null;
    }

    private CachingArtifactTypeRegistry(ArtifactTypeRegistry delegate) {
        this.delegate = delegate;
        this.types = new HashMap<String, ArtifactType>();
    }

    @Override
    public ArtifactType get(String typeId) {
        ArtifactType type2 = this.types.get(typeId);
        if (type2 == null) {
            type2 = this.delegate.get(typeId);
            this.types.put(typeId, type2);
        }
        return type2;
    }
}

