/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.NoTransporterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class DefaultTransporterProvider
implements TransporterProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTransporterProvider.class);
    private Collection<TransporterFactory> factories = new ArrayList<TransporterFactory>();

    public DefaultTransporterProvider() {
    }

    @Inject
    DefaultTransporterProvider(Set<TransporterFactory> transporterFactories) {
        this.setTransporterFactories(transporterFactories);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setTransporterFactories(locator.getServices(TransporterFactory.class));
    }

    public DefaultTransporterProvider addTransporterFactory(TransporterFactory factory) {
        this.factories.add(Objects.requireNonNull(factory, "transporter factory cannot be null"));
        return this;
    }

    public DefaultTransporterProvider setTransporterFactories(Collection<TransporterFactory> factories) {
        this.factories = factories == null ? new ArrayList<TransporterFactory>() : factories;
        return this;
    }

    @Override
    public Transporter newTransporter(RepositorySystemSession session2, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(repository, "remote repository cannot be null");
        PrioritizedComponents<TransporterFactory> factories = new PrioritizedComponents<TransporterFactory>(session2);
        for (TransporterFactory transporterFactory : this.factories) {
            factories.add(transporterFactory, transporterFactory.getPriority());
        }
        ArrayList<NoTransporterException> errors2 = new ArrayList<NoTransporterException>();
        for (PrioritizedComponent prioritizedComponent : factories.getEnabled()) {
            try {
                Transporter transporter = ((TransporterFactory)prioritizedComponent.getComponent()).newInstance(session2, repository);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder buffer2 = new StringBuilder(256);
                    buffer2.append("Using transporter ").append(transporter.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer2, transporter);
                    buffer2.append(" with priority ").append(prioritizedComponent.getPriority());
                    buffer2.append(" for ").append(repository.getUrl());
                    LOGGER.debug(buffer2.toString());
                }
                return transporter;
            }
            catch (NoTransporterException e2) {
                errors2.add(e2);
            }
        }
        if (LOGGER.isDebugEnabled() && errors2.size() > 1) {
            for (Exception exception : errors2) {
                LOGGER.debug("Could not obtain transporter factory for {}", (Object)repository, (Object)exception);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (factories.isEmpty()) {
            stringBuilder.append("No transporter factories registered");
        } else {
            stringBuilder.append("Cannot access ").append(repository.getUrl());
            stringBuilder.append(" using the registered transporter factories: ");
            factories.list(stringBuilder);
        }
        throw new NoTransporterException(repository, stringBuilder.toString(), errors2.size() == 1 ? (NoTransporterException)errors2.get(0) : null);
    }
}

