/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.apache.maven.toolchain.model.TrackableBase;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenToolchainsXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public MavenToolchainsXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source2, String fieldName) {
                return source2;
            }
        });
    }

    public MavenToolchainsXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias2, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias2)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s2, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s2, attribute, parser, null);
    }

    private boolean getBooleanValue(String s2, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s2 != null && s2.length() != 0) {
            return Boolean.valueOf(s2);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Byte.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s2, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s2 != null) {
            return s2.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s2, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s2, attribute, null, parser);
    }

    private Date getDateValue(String s2, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s2 != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s2));
                }
                catch (NumberFormatException e2) {
                    throw new XmlPullParserException(e2.getMessage(), parser, e2);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s2);
            }
            catch (ParseException e3) {
                throw new XmlPullParserException(e3.getMessage(), parser, e3);
            }
        }
        return null;
    }

    private double getDoubleValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Double.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Float.valueOf(s2).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Integer.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Long.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s2 == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s2;
    }

    private short getShortValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Short.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s2) {
        if (s2 != null) {
            s2 = s2.trim();
        }
        return s2;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public PersistedToolchains read(Reader reader2, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader2);
        return this.read(parser, strict);
    }

    public PersistedToolchains read(Reader reader2) throws IOException, XmlPullParserException {
        return this.read(reader2, true);
    }

    public PersistedToolchains read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in), strict);
    }

    public PersistedToolchains read(InputStream in) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in));
    }

    private PersistedToolchains parsePersistedToolchains(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PersistedToolchains persistedToolchains = new PersistedToolchains();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name2 = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name2.indexOf(58) >= 0 || "xmlns".equals(name2)) continue;
            this.checkUnknownAttribute(parser, name2, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if ("toolchain".equals(parser.getName())) {
                List<ToolchainModel> toolchains = persistedToolchains.getToolchains();
                if (toolchains == null) {
                    toolchains = new ArrayList<ToolchainModel>();
                    persistedToolchains.setToolchains(toolchains);
                }
                toolchains.add(this.parseToolchainModel(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return persistedToolchains;
    }

    private ToolchainModel parseToolchainModel(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String value;
        String tagName = parser.getName();
        ToolchainModel toolchainModel = new ToolchainModel();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name2 = parser.getAttributeName(i);
            value = parser.getAttributeValue(i);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name2, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                toolchainModel.setType(this.interpolatedTrimmed(parser.nextText(), "type"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "provides", null, parsed)) {
                while (parser.nextTag() == 2) {
                    String key2 = parser.getName();
                    value = parser.nextText().trim();
                    toolchainModel.addProvide(key2, value);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                toolchainModel.setConfiguration(Xpp3DomBuilder.build(parser, true));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return toolchainModel;
    }

    private TrackableBase parseTrackableBase(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        TrackableBase trackableBase = new TrackableBase();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name2 = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name2, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return trackableBase;
    }

    private PersistedToolchains read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PersistedToolchains persistedToolchains = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"toolchains".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'toolchains' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'toolchains'", parser, null);
                }
                persistedToolchains = this.parsePersistedToolchains(parser, strict);
                persistedToolchains.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return persistedToolchains;
        }
        throw new XmlPullParserException("Expected root element 'toolchains' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

