/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Asserts;
import org.apache.http.util.CharArrayBuffer;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractAuthenticationHandler
implements AuthenticationHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final List<String> DEFAULT_SCHEME_PRIORITY = Collections.unmodifiableList(Arrays.asList("Negotiate", "NTLM", "Digest", "Basic"));

    protected Map<String, Header> parseChallenges(Header[] headers) throws MalformedChallengeException {
        HashMap<String, Header> map2 = new HashMap<String, Header>(headers.length);
        for (Header header : headers) {
            int pos;
            CharArrayBuffer buffer2;
            if (header instanceof FormattedHeader) {
                buffer2 = ((FormattedHeader)header).getBuffer();
                pos = ((FormattedHeader)header).getValuePos();
            } else {
                String s2 = header.getValue();
                if (s2 == null) {
                    throw new MalformedChallengeException("Header value is null");
                }
                buffer2 = new CharArrayBuffer(s2.length());
                buffer2.append(s2);
                pos = 0;
            }
            while (pos < buffer2.length() && HTTP.isWhitespace(buffer2.charAt(pos))) {
                ++pos;
            }
            int beginIndex = pos;
            while (pos < buffer2.length() && !HTTP.isWhitespace(buffer2.charAt(pos))) {
                ++pos;
            }
            int endIndex = pos;
            String s3 = buffer2.substring(beginIndex, endIndex);
            map2.put(s3.toLowerCase(Locale.ROOT), header);
        }
        return map2;
    }

    protected List<String> getAuthPreferences() {
        return DEFAULT_SCHEME_PRIORITY;
    }

    protected List<String> getAuthPreferences(HttpResponse response, HttpContext context) {
        return this.getAuthPreferences();
    }

    @Override
    public AuthScheme selectScheme(Map<String, Header> challenges, HttpResponse response, HttpContext context) throws AuthenticationException {
        AuthSchemeRegistry registry2 = (AuthSchemeRegistry)context.getAttribute("http.authscheme-registry");
        Asserts.notNull(registry2, "AuthScheme registry");
        List<String> authPrefs = this.getAuthPreferences(response, context);
        if (authPrefs == null) {
            authPrefs = DEFAULT_SCHEME_PRIORITY;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Authentication schemes in the order of preference: " + authPrefs);
        }
        AuthScheme authScheme = null;
        for (String id : authPrefs) {
            Header challenge = challenges.get(id.toLowerCase(Locale.ENGLISH));
            if (challenge != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(id + " authentication scheme selected");
                }
                try {
                    authScheme = registry2.getAuthScheme(id, response.getParams());
                    break;
                }
                catch (IllegalStateException e2) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn("Authentication scheme " + id + " not supported");
                    continue;
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Challenge for " + id + " authentication scheme not available");
        }
        if (authScheme == null) {
            throw new AuthenticationException("Unable to respond to any of these challenges: " + challenges);
        }
        return authScheme;
    }
}

