/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.ContainerFocusOwnerFinder;
import org.fest.swing.core.FocusOwnerFinderStrategy;
import org.fest.swing.core.HierarchyRootsSource;

class HierarchyBasedFocusOwnerFinder
implements FocusOwnerFinderStrategy {
    private final ContainerFocusOwnerFinder delegate;
    private final HierarchyRootsSource rootsSource;

    HierarchyBasedFocusOwnerFinder() {
        this(new ContainerFocusOwnerFinder(), new HierarchyRootsSource());
    }

    HierarchyBasedFocusOwnerFinder(ContainerFocusOwnerFinder newDelegate, HierarchyRootsSource newRootsSource) {
        this.delegate = newDelegate;
        this.rootsSource = newRootsSource;
    }

    @RunsInCurrentThread
    public Component focusOwner() {
        for (Container c : this.rootsSource.existingHierarchyRoots()) {
            Component focus = this.delegate.focusOwnerOf(c);
            if (focus == null) continue;
            return focus;
        }
        return null;
    }
}

